/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.primitives.Ints;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.data.CompressedBlockReader;
import org.apache.druid.segment.data.CompressedLongsReader;

public final class CompressedVariableSizedBlobColumn
implements Closeable {
    private final int numElements;
    private final CompressedLongsReader compressedOffsets;
    private final CompressedBlockReader compressedBlocks;
    private final Closer closer;

    public CompressedVariableSizedBlobColumn(int numElements, CompressedLongsReader offsetsReader, CompressedBlockReader blockReader) {
        this.numElements = numElements;
        this.compressedOffsets = offsetsReader;
        this.compressedBlocks = blockReader;
        this.closer = Closer.create();
        this.closer.register(this.compressedOffsets);
        this.closer.register(this.compressedBlocks);
    }

    public int size() {
        return this.numElements;
    }

    public ByteBuffer get(int index) {
        long endOffset;
        long startOffset;
        if (index == 0) {
            startOffset = 0L;
            endOffset = this.compressedOffsets.get(0);
        } else {
            startOffset = this.compressedOffsets.get(index - 1);
            endOffset = this.compressedOffsets.get(index);
        }
        int size = Ints.checkedCast((long)(endOffset - startOffset));
        return this.compressedBlocks.getRange(startOffset, size);
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }
}

