/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.StampedLock;
import javax.annotation.Nullable;
import org.apache.druid.segment.SortedDimensionDictionary;

public abstract class DimensionDictionary<T extends Comparable<T>> {
    public static final int ABSENT_VALUE_ID = -1;
    private final Class<T> cls;
    @Nullable
    private T minValue = null;
    @Nullable
    private T maxValue = null;
    private volatile int idForNull = -1;
    private final AtomicLong sizeInBytes = new AtomicLong(0L);
    private final Object2IntMap<T> valueToId = new Object2IntOpenHashMap();
    private final List<T> idToValue = new ArrayList<T>();
    private final StampedLock lock;

    public DimensionDictionary(Class<T> cls) {
        this.cls = cls;
        this.lock = new StampedLock();
        this.valueToId.defaultReturnValue(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getId(@Nullable T value) {
        if (value == null) {
            return this.idForNull;
        }
        long stamp = this.lock.readLock();
        try {
            int n = this.valueToId.getInt(value);
            return n;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getValue(int id) {
        if (id == this.idForNull) {
            return null;
        }
        long stamp = this.lock.tryOptimisticRead();
        Comparable output = (Comparable)this.idToValue.get(id);
        if (this.lock.validate(stamp)) {
            return (T)output;
        }
        stamp = this.lock.readLock();
        try {
            Comparable comparable = (Comparable)this.idToValue.get(id);
            return (T)comparable;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T[] getValues(int[] ids) {
        Comparable[] values = (Comparable[])Array.newInstance(this.cls, ids.length);
        long stamp = this.lock.readLock();
        try {
            for (int i = 0; i < ids.length; ++i) {
                values[i] = (Comparable)this.idToValue.get(ids[i]);
            }
            Comparable[] comparableArray = values;
            return comparableArray;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        long stamp = this.lock.tryOptimisticRead();
        int size = this.idToValue.size();
        if (this.lock.validate(stamp)) {
            return size;
        }
        stamp = this.lock.readLock();
        try {
            int n = this.idToValue.size();
            return n;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    public long sizeInBytes() {
        if (!this.computeOnHeapSize()) {
            throw new IllegalStateException("On-heap size computation is disabled");
        }
        return this.sizeInBytes.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(@Nullable T originalValue) {
        if (originalValue == null) {
            return this.addNull();
        }
        long stamp = this.lock.tryReadLock();
        if (stamp != 0L) {
            try {
                int existing = this.valueToId.getInt(originalValue);
                if (existing >= 0) {
                    int n = existing;
                    return n;
                }
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }
        long extraSize = 0L;
        if (this.computeOnHeapSize()) {
            extraSize = this.estimateSizeOfValue(originalValue) + 16L;
        }
        stamp = this.lock.writeLock();
        try {
            int index = this.idToValue.size();
            int prev = this.valueToId.putIfAbsent(originalValue, index);
            if (prev >= 0) {
                int n = prev;
                return n;
            }
            this.idToValue.add(originalValue);
            this.sizeInBytes.addAndGet(extraSize);
            this.minValue = this.minValue == null || this.minValue.compareTo(originalValue) > 0 ? originalValue : this.minValue;
            this.maxValue = this.maxValue == null || this.maxValue.compareTo(originalValue) < 0 ? originalValue : this.maxValue;
            int n = index;
            return n;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addNull() {
        if (this.idForNull != -1) {
            return this.idForNull;
        }
        long stamp = this.lock.writeLock();
        try {
            if (this.idForNull == -1) {
                this.idForNull = this.idToValue.size();
                this.idToValue.add(null);
            }
            int n = this.idForNull;
            return n;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getMinValue() {
        long stamp = this.lock.tryOptimisticRead();
        T output = this.minValue;
        if (this.lock.validate(stamp)) {
            return output;
        }
        stamp = this.lock.readLock();
        try {
            T t = this.minValue;
            return t;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getMaxValue() {
        long stamp = this.lock.tryOptimisticRead();
        T output = this.maxValue;
        if (this.lock.validate(stamp)) {
            return output;
        }
        stamp = this.lock.readLock();
        try {
            T t = this.maxValue;
            return t;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    public int getIdForNull() {
        return this.idForNull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedDimensionDictionary<T> sort() {
        long stamp = this.lock.readLock();
        try {
            SortedDimensionDictionary<T> sortedDimensionDictionary = new SortedDimensionDictionary<T>(this.idToValue, this.idToValue.size());
            return sortedDimensionDictionary;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    public abstract long estimateSizeOfValue(T var1);

    public abstract boolean computeOnHeapSize();
}

