/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.Groupers;
import org.apache.druid.query.groupby.epinephelinae.ReusableEntry;
import org.apache.druid.query.groupby.epinephelinae.VectorGrouper;
import org.apache.druid.query.groupby.epinephelinae.collection.HashTableUtils;
import org.apache.druid.query.groupby.epinephelinae.collection.MemoryOpenHashTable;
import org.apache.druid.query.groupby.epinephelinae.collection.MemoryPointer;

public class HashVectorGrouper
implements VectorGrouper {
    private static final int MIN_BUCKETS = 4;
    private static final int DEFAULT_INITIAL_BUCKETS = 1024;
    private static final float DEFAULT_MAX_LOAD_FACTOR = 0.7f;
    private boolean initialized = false;
    private int maxNumBuckets;
    private final Supplier<ByteBuffer> bufferSupplier;
    private final AggregatorAdapters aggregators;
    private final int keySize;
    private final int bufferGrouperMaxSize;
    private final int configuredInitialNumBuckets;
    private final int bucketSize;
    private final float maxLoadFactor;
    private ByteBuffer buffer;
    private int tableStart = 0;
    @Nullable
    private MemoryOpenHashTable hashTable;
    @Nullable
    private int[] vKeyHashCodes = null;
    @Nullable
    private int[] vAggregationPositions = null;
    @Nullable
    private int[] vAggregationRows = null;

    public HashVectorGrouper(Supplier<ByteBuffer> bufferSupplier, int keySize, AggregatorAdapters aggregators, int bufferGrouperMaxSize, float maxLoadFactor, int configuredInitialNumBuckets) {
        this.bufferSupplier = bufferSupplier;
        this.keySize = keySize;
        this.aggregators = aggregators;
        this.bufferGrouperMaxSize = bufferGrouperMaxSize;
        this.maxLoadFactor = maxLoadFactor > 0.0f ? maxLoadFactor : 0.7f;
        this.configuredInitialNumBuckets = configuredInitialNumBuckets >= 4 ? configuredInitialNumBuckets : 1024;
        this.bucketSize = MemoryOpenHashTable.bucketSize(keySize, aggregators.spaceNeeded());
        if (this.maxLoadFactor >= 1.0f) {
            throw new IAE("Invalid maxLoadFactor[%f], must be < 1.0", Float.valueOf(maxLoadFactor));
        }
    }

    @Override
    public void initVectorized(int maxVectorSize) {
        if (!this.initialized) {
            this.buffer = (ByteBuffer)this.bufferSupplier.get();
            this.maxNumBuckets = Math.max(HashVectorGrouper.computeRoundedInitialNumBuckets(this.buffer.capacity(), this.bucketSize, this.configuredInitialNumBuckets), HashVectorGrouper.computeMaxNumBucketsAfterGrowth(this.buffer.capacity(), this.bucketSize));
            this.reset();
            this.vKeyHashCodes = new int[maxVectorSize];
            this.vAggregationPositions = new int[maxVectorSize];
            this.vAggregationRows = new int[maxVectorSize];
            this.initialized = true;
        }
    }

    @Override
    public AggregateResult aggregateVector(Memory keySpace, int startRow, int endRow) {
        int numRows = endRow - startRow;
        if (keySpace.getCapacity() < (long)numRows * (long)this.keySize) {
            throw new IAE("Not enough keySpace capacity for the provided start/end rows", new Object[0]);
        }
        if (keySpace.getCapacity() > Integer.MAX_VALUE) {
            throw new ISE("keySpace too large to handle", new Object[0]);
        }
        int rowNum = 0;
        int keySpacePosition = 0;
        while (rowNum < numRows) {
            this.vKeyHashCodes[rowNum] = Groupers.smear(HashTableUtils.hashMemory(keySpace, keySpacePosition, this.keySize));
            ++rowNum;
            keySpacePosition += this.keySize;
        }
        int aggregationStartRow = startRow;
        int aggregationNumRows = 0;
        int aggregatorStartOffset = this.hashTable.bucketValueOffset();
        int rowNum2 = 0;
        int keySpacePosition2 = 0;
        while (rowNum2 < numRows) {
            int bucket = this.hashTable.findBucket(this.vKeyHashCodes[rowNum2], keySpace, keySpacePosition2);
            if (bucket < 0) {
                if (this.hashTable.canInsertNewBucket()) {
                    bucket = -(bucket + 1);
                    this.initBucket(bucket, keySpace, keySpacePosition2);
                } else {
                    if (aggregationNumRows > 0) {
                        this.doAggregateVector(aggregationStartRow, aggregationNumRows);
                        aggregationStartRow += aggregationNumRows;
                        aggregationNumRows = 0;
                    }
                    if (this.grow() && this.hashTable.canInsertNewBucket()) {
                        bucket = this.hashTable.findBucket(this.vKeyHashCodes[rowNum2], keySpace, keySpacePosition2);
                        bucket = -(bucket + 1);
                        this.initBucket(bucket, keySpace, keySpacePosition2);
                    } else {
                        return Groupers.hashTableFull(rowNum2);
                    }
                }
            }
            this.vAggregationPositions[aggregationNumRows] = bucket * this.bucketSize + aggregatorStartOffset;
            ++aggregationNumRows;
            ++rowNum2;
            keySpacePosition2 += this.keySize;
        }
        if (aggregationNumRows > 0) {
            this.doAggregateVector(aggregationStartRow, aggregationNumRows);
        }
        return AggregateResult.ok();
    }

    @Override
    public void reset() {
        int numBuckets = HashVectorGrouper.computeRoundedInitialNumBuckets(this.buffer.capacity(), this.bucketSize, this.configuredInitialNumBuckets);
        assert (numBuckets <= this.maxNumBuckets);
        this.tableStart = numBuckets == this.maxNumBuckets ? 0 : this.buffer.capacity() - this.bucketSize * (this.maxNumBuckets - numBuckets);
        this.hashTable = this.createTable(this.buffer, this.tableStart, numBuckets);
        this.aggregators.reset();
    }

    @Override
    public CloseableIterator<Grouper.Entry<MemoryPointer>> iterator() {
        if (!this.initialized) {
            return CloseableIterators.withEmptyBaggage(Collections.emptyIterator());
        }
        final IntIterator baseIterator = this.hashTable.bucketIterator();
        return new CloseableIterator<Grouper.Entry<MemoryPointer>>(){
            final MemoryPointer reusableKey = new MemoryPointer();
            final ReusableEntry<MemoryPointer> reusableEntry;
            {
                this.reusableEntry = new ReusableEntry<MemoryPointer>(this.reusableKey, new Object[HashVectorGrouper.this.aggregators.size()]);
            }

            @Override
            public boolean hasNext() {
                return baseIterator.hasNext();
            }

            @Override
            public Grouper.Entry<MemoryPointer> next() {
                int bucket = baseIterator.nextInt();
                int bucketPosition = HashVectorGrouper.this.hashTable.bucketMemoryPosition(bucket);
                this.reusableKey.set((Memory)HashVectorGrouper.this.hashTable.memory(), bucketPosition + HashVectorGrouper.this.hashTable.bucketKeyOffset());
                int aggregatorsOffset = bucketPosition + HashVectorGrouper.this.hashTable.bucketValueOffset();
                for (int i = 0; i < HashVectorGrouper.this.aggregators.size(); ++i) {
                    this.reusableEntry.getValues()[i] = HashVectorGrouper.this.aggregators.get(HashVectorGrouper.this.hashTable.memory().getByteBuffer(), aggregatorsOffset, i);
                }
                return this.reusableEntry;
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public void close() {
        this.aggregators.reset();
    }

    @VisibleForTesting
    public int getTableStart() {
        return this.tableStart;
    }

    private MemoryOpenHashTable createTable(ByteBuffer buffer, int tableStart, int numBuckets) {
        ByteBuffer tableBuffer = buffer.duplicate();
        tableBuffer.position(tableStart);
        assert (tableStart + MemoryOpenHashTable.memoryNeeded(numBuckets, this.bucketSize) <= buffer.capacity());
        tableBuffer.limit(tableStart + MemoryOpenHashTable.memoryNeeded(numBuckets, this.bucketSize));
        return new MemoryOpenHashTable(WritableMemory.writableWrap((ByteBuffer)tableBuffer.slice(), (ByteOrder)ByteOrder.nativeOrder()), numBuckets, Math.max(1, Math.min(this.bufferGrouperMaxSize, (int)((float)numBuckets * this.maxLoadFactor))), this.keySize, this.aggregators.spaceNeeded());
    }

    private void initBucket(int bucket, Memory keySpace, int keySpacePosition) {
        assert (bucket >= 0 && bucket < this.maxNumBuckets && this.hashTable != null && this.hashTable.canInsertNewBucket());
        this.hashTable.initBucket(bucket, keySpace, keySpacePosition);
        this.aggregators.init(this.hashTable.memory().getByteBuffer(), bucket * this.bucketSize + this.hashTable.bucketValueOffset());
    }

    private void doAggregateVector(int startRow, int numRows) {
        this.aggregators.aggregateVector(this.hashTable.memory().getByteBuffer(), numRows, this.vAggregationPositions, Groupers.writeAggregationRows(this.vAggregationRows, startRow, startRow + numRows));
    }

    private boolean grow() {
        if (this.hashTable.numBuckets() >= this.maxNumBuckets) {
            return false;
        }
        int newNumBuckets = this.nextTableNumBuckets();
        int newTableStart = this.nextTableStart();
        MemoryOpenHashTable newHashTable = this.createTable(this.buffer, newTableStart, newNumBuckets);
        this.hashTable.copyTo(newHashTable, new HashVectorGrouperBucketCopyHandler(this.aggregators, this.hashTable.bucketValueOffset()));
        this.hashTable = newHashTable;
        this.tableStart = newTableStart;
        return true;
    }

    private int nextTableNumBuckets() {
        if (!this.initialized) {
            throw new ISE("Must be initialized", new Object[0]);
        }
        if (this.hashTable.numBuckets() >= this.maxNumBuckets) {
            throw new ISE("No room left to grow", new Object[0]);
        }
        return this.hashTable.numBuckets() * 2;
    }

    private int nextTableStart() {
        int nextTableStart;
        if (!this.initialized) {
            throw new ISE("Must be initialized", new Object[0]);
        }
        int nextNumBuckets = this.nextTableNumBuckets();
        int currentEnd = this.tableStart + MemoryOpenHashTable.memoryNeeded(this.hashTable.numBuckets(), this.bucketSize);
        if (nextNumBuckets == this.maxNumBuckets) {
            assert (currentEnd == this.buffer.capacity());
            nextTableStart = 0;
        } else {
            nextTableStart = currentEnd;
        }
        long nextEnd = (long)nextTableStart + (long)MemoryOpenHashTable.memoryNeeded(nextNumBuckets, this.bucketSize);
        if (nextEnd > (long)this.buffer.capacity()) {
            throw new ISE("New table overruns buffer capacity", new Object[0]);
        }
        if (nextTableStart < currentEnd && nextEnd > (long)this.tableStart) {
            throw new ISE("New table overruns old table", new Object[0]);
        }
        return nextTableStart;
    }

    private static int computeRoundedInitialNumBuckets(int capacity, int bucketSize, int configuredInitialNumBuckets) {
        int initialNumBucketsRoundedUp = (int)Math.min(0x40000000L, HashCommon.nextPowerOfTwo((long)configuredInitialNumBuckets));
        if (initialNumBucketsRoundedUp < HashVectorGrouper.computeMaxNumBucketsAfterGrowth(capacity, bucketSize)) {
            return initialNumBucketsRoundedUp;
        }
        return HashTableUtils.previousPowerOfTwo(Math.min(capacity / bucketSize, 0x40000000));
    }

    private static int computeMaxNumBucketsAfterGrowth(int capacity, int bucketSize) {
        return HashTableUtils.previousPowerOfTwo(Math.min(capacity / bucketSize / 3 * 2, 0x40000000));
    }

    private static class HashVectorGrouperBucketCopyHandler
    implements MemoryOpenHashTable.BucketCopyHandler {
        private final AggregatorAdapters aggregators;
        private final int baseAggregatorOffset;

        public HashVectorGrouperBucketCopyHandler(AggregatorAdapters aggregators, int bucketAggregatorOffset) {
            this.aggregators = aggregators;
            this.baseAggregatorOffset = bucketAggregatorOffset;
        }

        @Override
        public void bucketCopied(int oldBucket, int newBucket, MemoryOpenHashTable oldTable, MemoryOpenHashTable newTable) {
            this.aggregators.relocate(oldTable.bucketMemoryPosition(oldBucket) + this.baseAggregatorOffset, newTable.bucketMemoryPosition(newBucket) + this.baseAggregatorOffset, oldTable.memory().getByteBuffer(), newTable.memory().getByteBuffer());
        }
    }
}

