/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.AlertBuilder;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;

public class EmittingLogger
extends Logger {
    private static volatile ServiceEmitter emitter = null;
    private final String className;

    public static void registerEmitter(ServiceEmitter emitter) {
        Preconditions.checkNotNull((Object)emitter);
        EmittingLogger.emitter = emitter;
    }

    public EmittingLogger(Class clazz) {
        super(clazz);
        this.className = clazz.getName();
    }

    private EmittingLogger(org.slf4j.Logger log, boolean stackTraces) {
        super(log, stackTraces);
        this.className = log.getName();
    }

    @Override
    public EmittingLogger noStackTrace() {
        return new EmittingLogger(this.getSlf4jLogger(), false);
    }

    public AlertBuilder makeWarningAlert(String message, Object ... objects) {
        return this.makeAlert(null, false, message, objects);
    }

    public AlertBuilder makeAlert(String message, Object ... objects) {
        return this.makeAlert(null, true, message, objects);
    }

    public AlertBuilder makeAlert(@Nullable Throwable t, String message, Object ... objects) {
        return this.makeAlert(t, true, message, objects);
    }

    public AlertBuilder makeAlert(@Nullable Throwable t, boolean isError, String message, Object ... objects) {
        if (emitter == null) {
            String errorMessage = StringUtils.format("Emitter not initialized!  Cannot alert.  Please make sure to call %s.registerEmitter()\nMessage: %s", this.getClass(), StringUtils.nonStrictFormat(message, objects));
            ISE e = new ISE(errorMessage, new Object[0]);
            if (t != null) {
                e.addSuppressed(t);
            }
            this.error(e, errorMessage, new Object[0]);
            throw e;
        }
        return new LoggingAlertBuilder(t, StringUtils.format(message, objects), emitter, isError).addData("class", this.className);
    }

    public class LoggingAlertBuilder
    extends AlertBuilder {
        private final Throwable t;
        private final boolean isError;
        private volatile boolean emitted;

        private LoggingAlertBuilder(Throwable t, String description, ServiceEmitter emitter, boolean isError) {
            super(description, emitter);
            this.emitted = false;
            this.t = t;
            this.isError = isError;
            this.addThrowable(t);
        }

        @Override
        public void emit() {
            this.logIt("%s: %s");
            this.emitted = true;
            super.emit();
        }

        protected void finalize() {
            if (!this.emitted) {
                this.logIt("Alert not emitted, emitting. %s: %s");
                super.emit();
            }
        }

        private void logIt(String format) {
            if (this.t == null) {
                if (this.isError) {
                    EmittingLogger.this.error(format, this.description, this.dataMap);
                } else {
                    EmittingLogger.this.warn(format, this.description, this.dataMap);
                }
            } else {
                Map filteredDataMap = Maps.filterKeys((Map)this.dataMap, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)"exceptionStackTrace")));
                if (this.isError) {
                    EmittingLogger.this.error(this.t, format, this.description, filteredDataMap);
                } else {
                    EmittingLogger.this.warn(this.t, format, this.description, filteredDataMap);
                }
            }
        }
    }
}

