/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.Arrays;
import org.apache.druid.java.util.common.IAE;

public class TournamentTree {
    private final int[] tree;
    private final int numElements;
    private final int numElementsRounded;
    private final IntComparator comparator;
    private boolean initialized;

    public TournamentTree(int numElements, IntComparator comparator) {
        if (numElements < 1) {
            throw new IAE("Must have at least one element", new Object[0]);
        }
        this.numElements = numElements;
        this.numElementsRounded = HashCommon.nextPowerOfTwo((int)numElements);
        this.comparator = comparator;
        this.tree = new int[this.numElementsRounded];
    }

    public int getMin() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        this.update();
        return this.tree[0];
    }

    public String toString() {
        return "TournamentTree{numElements=" + this.numElementsRounded + ", tree=" + Arrays.toString(this.tree) + "}";
    }

    @VisibleForTesting
    int[] backingArray() {
        return this.tree;
    }

    private void initialize() {
        if (this.numElements == 1) {
            return;
        }
        int[] winnerTree = new int[this.numElementsRounded];
        for (int i = 0; i < this.numElementsRounded; i += 2) {
            int loser;
            int winner;
            int cmp = this.compare(i, i + 1);
            if (cmp <= 0) {
                winner = i;
                loser = i + 1;
            } else {
                winner = i + 1;
                loser = i;
            }
            int nodeIndex = this.tree.length + i >> 1;
            this.tree[nodeIndex] = loser;
            winnerTree[nodeIndex] = winner;
        }
        for (int layerSize = this.numElementsRounded >> 1; layerSize > 1; layerSize >>= 1) {
            for (int i = 0; i < layerSize; i += 2) {
                int loser;
                int winner;
                int left = winnerTree[layerSize + i];
                int right = winnerTree[layerSize + i + 1];
                int cmp = this.compare(left, right);
                if (cmp <= 0) {
                    winner = left;
                    loser = right;
                } else {
                    winner = right;
                    loser = left;
                }
                int nodeIndex = layerSize + i >> 1;
                this.tree[nodeIndex] = loser;
                winnerTree[nodeIndex] = winner;
            }
        }
        this.tree[0] = winnerTree[1];
    }

    private void update() {
        int current = this.tree[0];
        for (int nodeIndex = (current & 0xFFFFFFFE) + this.tree.length >> 1; nodeIndex >= 1; nodeIndex >>= 1) {
            int nodeLoser = this.tree[nodeIndex];
            int cmp = this.compare(current, nodeLoser);
            if (cmp <= 0) continue;
            this.tree[nodeIndex] = current;
            current = nodeLoser;
        }
        this.tree[0] = current;
    }

    private int compare(int a, int b) {
        if (b >= this.numElements || a >= this.numElements) {
            return Integer.compare(a, b);
        }
        return this.comparator.compare(a, b);
    }
}

