/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.java.util.common.ISE;

public class Bouncer {
    private final int maxCount;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private int currentCount = 0;
    @GuardedBy(value="lock")
    private final Queue<SettableFuture<Ticket>> waiters = new ArrayDeque<SettableFuture<Ticket>>();

    public Bouncer(int maxCount) {
        this.maxCount = maxCount;
        if (maxCount <= 0) {
            throw new ISE("maxConcurrentWorkers must be greater than zero", new Object[0]);
        }
    }

    public static Bouncer unlimited() {
        return new Bouncer(Integer.MAX_VALUE);
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Ticket> ticket() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentCount < this.maxCount) {
                ++this.currentCount;
                return Futures.immediateFuture((Object)new Ticket());
            }
            SettableFuture future = SettableFuture.create();
            this.waiters.add((SettableFuture<Ticket>)future);
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getCurrentCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentCount;
        }
    }

    public class Ticket {
        private final AtomicBoolean givenBack = new AtomicBoolean();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void giveBack() {
            SettableFuture<Ticket> nextFuture;
            if (!this.givenBack.compareAndSet(false, true)) {
                return;
            }
            do {
                Object object = Bouncer.this.lock;
                synchronized (object) {
                    nextFuture = Bouncer.this.waiters.poll();
                    if (nextFuture == null) {
                        --Bouncer.this.currentCount;
                        return;
                    }
                }
            } while (!nextFuture.set((Object)new Ticket()));
        }
    }
}

