/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import com.amazonaws.services.kinesis.model.AddTagsToStreamRequest;
import com.amazonaws.services.kinesis.model.AddTagsToStreamResult;
import com.amazonaws.services.kinesis.model.CreateStreamResult;
import com.amazonaws.services.kinesis.model.DeleteStreamResult;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.ScalingType;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.StreamDescription;
import com.amazonaws.services.kinesis.model.StreamStatus;
import com.amazonaws.services.kinesis.model.UpdateShardCountRequest;
import com.amazonaws.services.kinesis.model.UpdateShardCountResult;
import com.amazonaws.util.AwsHostNameUtils;
import com.google.common.collect.Iterables;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.testing.utils.StreamAdminClient;

public class KinesisAdminClient
implements StreamAdminClient {
    private final AmazonKinesis amazonKinesis;

    public KinesisAdminClient(String endpoint) throws Exception {
        String pathToConfigFile = System.getProperty("override.config.path");
        Properties prop = new Properties();
        prop.load(new FileInputStream(pathToConfigFile));
        AWSStaticCredentialsProvider credentials = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(prop.getProperty("druid_kinesis_accessKey"), prop.getProperty("druid_kinesis_secretKey")));
        this.amazonKinesis = (AmazonKinesis)((AmazonKinesisClientBuilder)((AmazonKinesisClientBuilder)((AmazonKinesisClientBuilder)AmazonKinesisClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentials)).withClientConfiguration(new ClientConfiguration())).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, AwsHostNameUtils.parseRegion((String)endpoint, null)))).build();
    }

    @Override
    public void createStream(String streamName, int shardCount, Map<String, String> tags) {
        CreateStreamResult createStreamResult = this.amazonKinesis.createStream(streamName, Integer.valueOf(shardCount));
        if (createStreamResult.getSdkHttpMetadata().getHttpStatusCode() != 200) {
            throw new ISE("Cannot create stream for integration test", new Object[0]);
        }
        if (tags != null && !tags.isEmpty()) {
            AddTagsToStreamRequest addTagsToStreamRequest = new AddTagsToStreamRequest();
            addTagsToStreamRequest.setStreamName(streamName);
            addTagsToStreamRequest.setTags(tags);
            AddTagsToStreamResult addTagsToStreamResult = this.amazonKinesis.addTagsToStream(addTagsToStreamRequest);
            if (addTagsToStreamResult.getSdkHttpMetadata().getHttpStatusCode() != 200) {
                throw new ISE("Cannot tag stream for integration test", new Object[0]);
            }
        }
    }

    @Override
    public void deleteStream(String streamName) {
        DeleteStreamResult deleteStreamResult = this.amazonKinesis.deleteStream(streamName);
        if (deleteStreamResult.getSdkHttpMetadata().getHttpStatusCode() != 200) {
            throw new ISE("Cannot delete stream for integration test", new Object[0]);
        }
    }

    @Override
    public void updatePartitionCount(String streamName, int newShardCount, boolean blocksUntilStarted) {
        int originalShardCount = this.getStreamPartitionCount(streamName);
        if (originalShardCount == newShardCount) {
            return;
        }
        UpdateShardCountRequest updateShardCountRequest = new UpdateShardCountRequest();
        updateShardCountRequest.setStreamName(streamName);
        updateShardCountRequest.setTargetShardCount(Integer.valueOf(newShardCount));
        updateShardCountRequest.setScalingType(ScalingType.UNIFORM_SCALING);
        UpdateShardCountResult updateShardCountResult = this.amazonKinesis.updateShardCount(updateShardCountRequest);
        if (updateShardCountResult.getSdkHttpMetadata().getHttpStatusCode() != 200) {
            throw new ISE("Cannot update stream's shard count for integration test", new Object[0]);
        }
        if (blocksUntilStarted) {
            ITRetryUtil.retryUntil(() -> {
                int updatedShardCount = this.getStreamPartitionCount(streamName);
                return this.verifyStreamStatus(streamName, StreamStatus.ACTIVE, StreamStatus.UPDATING) && updatedShardCount != originalShardCount;
            }, true, 300L, 100, "Kinesis stream resharding to start (or finished)");
        }
    }

    @Override
    public boolean isStreamActive(String streamName) {
        return this.verifyStreamStatus(streamName, StreamStatus.ACTIVE);
    }

    @Override
    public int getStreamPartitionCount(String streamName) {
        HashSet shardIds = new HashSet();
        DescribeStreamRequest request = new DescribeStreamRequest();
        request.setStreamName(streamName);
        while (request != null) {
            StreamDescription description = this.amazonKinesis.describeStream(request).getStreamDescription();
            List shardIdResult = description.getShards().stream().map(Shard::getShardId).collect(Collectors.toList());
            shardIds.addAll(shardIdResult);
            if (description.isHasMoreShards().booleanValue()) {
                request.setExclusiveStartShardId((String)Iterables.getLast(shardIdResult));
                continue;
            }
            request = null;
        }
        return shardIds.size();
    }

    @Override
    public boolean verfiyPartitionCountUpdated(String streamName, int oldShardCount, int newShardCount) {
        int actualShardCount = this.getStreamPartitionCount(streamName);
        return actualShardCount == oldShardCount + newShardCount;
    }

    private boolean verifyStreamStatus(String streamName, StreamStatus ... streamStatuses) {
        return Arrays.stream(streamStatuses).map(StreamStatus::toString).anyMatch(this.getStreamStatus(streamName)::equals);
    }

    private String getStreamStatus(String streamName) {
        return this.getStreamDescription(streamName).getStreamStatus();
    }

    private StreamDescription getStreamDescription(String streamName) {
        DescribeStreamResult describeStreamResult = this.amazonKinesis.describeStream(streamName);
        if (describeStreamResult.getSdkHttpMetadata().getHttpStatusCode() != 200) {
            throw new ISE("Cannot get stream description for integration test", new Object[0]);
        }
        return describeStreamResult.getStreamDescription();
    }
}

