/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.tools.demo;

import java.io.IOException;
import java.util.HashMap;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionTypeEnum;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.OkHttpUtils;
import org.apache.dolphinscheduler.tools.demo.ProxyResult;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ProxyProcessDefinitionController {
    @Value(value="${demo.api-server-port}")
    private String ServerPort;
    @Value(value="${demo.domain-name}")
    private String DomainName;

    public ProxyResult createProcessDefinition(String token, long projectCode, String name, String description, String globalParams, String locations, int timeout, String tenantCode, String taskRelationJson, String taskDefinitionJson, WorkflowExecutionTypeEnum executionType) {
        String responseBody;
        ProxyResult proxyResult = new ProxyResult();
        String url = "http://" + this.DomainName + ":" + this.ServerPort + "/dolphinscheduler/projects/" + projectCode + "/process-definition";
        HashMap<String, Object> requestBodyMap = new HashMap<String, Object>();
        requestBodyMap.put("name", name);
        requestBodyMap.put("description", description);
        requestBodyMap.put("globalParams", globalParams);
        requestBodyMap.put("locations", locations);
        requestBodyMap.put("timeout", timeout);
        requestBodyMap.put("tenantCode", tenantCode);
        requestBodyMap.put("taskRelationJson", taskRelationJson);
        requestBodyMap.put("taskDefinitionJson", taskDefinitionJson);
        requestBodyMap.put("otherParamsJson", null);
        requestBodyMap.put("executionType", executionType);
        try {
            responseBody = OkHttpUtils.demoPost((String)url, (String)token, requestBodyMap);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        proxyResult = (ProxyResult)JSONUtils.parseObject((String)responseBody, ProxyResult.class);
        return proxyResult;
    }
}

