/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sqoop.generator.targets;

import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.ITargetGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.SqoopParameters;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.targets.TargetSqlServerParameter;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerTargetGenerator
implements ITargetGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerTargetGenerator.class);

    @Override
    public String generate(SqoopParameters sqoopParameters, SqoopTaskExecutionContext sqoopTaskExecutionContext) {
        StringBuilder oracleTargetSb = new StringBuilder();
        try {
            TargetSqlServerParameter targetSqlServerParameter = (TargetSqlServerParameter)JSONUtils.parseObject((String)sqoopParameters.getTargetParams(), TargetSqlServerParameter.class);
            if (null == targetSqlServerParameter || targetSqlServerParameter.getTargetDatasource() == 0) {
                return oracleTargetSb.toString();
            }
            BaseConnectionParam baseDataSource = (BaseConnectionParam)DataSourceUtils.buildConnectionParams((DbType)sqoopTaskExecutionContext.getTargetType(), (String)sqoopTaskExecutionContext.getTargetConnectionParams());
            if (null == baseDataSource) {
                return oracleTargetSb.toString();
            }
            oracleTargetSb.append(" ").append("--connect").append(" ").append("\"").append(DataSourceUtils.getJdbcUrl((DbType)DbType.SQLSERVER, (ConnectionParam)baseDataSource)).append("\"").append(" ").append(DataSourceUtils.getDatasourceDriver((DbType)DbType.SQLSERVER)).append(" ").append("--username").append(" ").append(baseDataSource.getUser()).append(" ").append("--password").append(" ").append("\"").append(PasswordUtils.decodePassword((String)baseDataSource.getPassword())).append("\"").append(" ").append("--table").append(" ").append(targetSqlServerParameter.getTargetTable());
            if (StringUtils.isNotEmpty((CharSequence)targetSqlServerParameter.getTargetColumns())) {
                oracleTargetSb.append(" ").append("--columns").append(" ").append(targetSqlServerParameter.getTargetColumns());
            }
            if (StringUtils.isNotEmpty((CharSequence)targetSqlServerParameter.getFieldsTerminated())) {
                oracleTargetSb.append(" ").append("--fields-terminated-by");
                if (targetSqlServerParameter.getFieldsTerminated().contains("'")) {
                    oracleTargetSb.append(" ").append(targetSqlServerParameter.getFieldsTerminated());
                } else {
                    oracleTargetSb.append(" ").append("'").append(targetSqlServerParameter.getFieldsTerminated()).append("'");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)targetSqlServerParameter.getLinesTerminated())) {
                oracleTargetSb.append(" ").append("--lines-terminated-by");
                if (targetSqlServerParameter.getLinesTerminated().contains("'")) {
                    oracleTargetSb.append(" ").append(targetSqlServerParameter.getLinesTerminated());
                } else {
                    oracleTargetSb.append(" ").append("'").append(targetSqlServerParameter.getLinesTerminated()).append("'");
                }
            }
            if (targetSqlServerParameter.getIsUpdate() && StringUtils.isNotEmpty((CharSequence)targetSqlServerParameter.getTargetUpdateKey()) && StringUtils.isNotEmpty((CharSequence)targetSqlServerParameter.getTargetUpdateMode())) {
                oracleTargetSb.append(" ").append("--update-key").append(" ").append(targetSqlServerParameter.getTargetUpdateKey()).append(" ").append("--update-mode").append(" ").append(targetSqlServerParameter.getTargetUpdateMode());
            }
        }
        catch (Exception e) {
            logger.error(String.format("Sqoop oracle target params build failed: [%s]", e.getMessage()));
        }
        return oracleTargetSb.toString();
    }
}

