/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sqoop.generator.sources;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopQueryType;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.ISourceGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.SqoopParameters;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.sources.SourceSqlServerParameter;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerSourceGenerator
implements ISourceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerSourceGenerator.class);

    @Override
    public String generate(SqoopParameters sqoopParameters, SqoopTaskExecutionContext sqoopTaskExecutionContext) {
        StringBuilder sqlServerSourceSb = new StringBuilder();
        try {
            SourceSqlServerParameter sourceSqlServerParameter = (SourceSqlServerParameter)JSONUtils.parseObject((String)sqoopParameters.getSourceParams(), SourceSqlServerParameter.class);
            if (null == sourceSqlServerParameter) {
                return sqlServerSourceSb.toString();
            }
            BaseConnectionParam baseDataSource = (BaseConnectionParam)DataSourceUtils.buildConnectionParams((DbType)sqoopTaskExecutionContext.getSourcetype(), (String)sqoopTaskExecutionContext.getSourceConnectionParams());
            if (null == baseDataSource) {
                return sqlServerSourceSb.toString();
            }
            sqlServerSourceSb.append(" ").append("--connect").append(" ").append("\"").append(DataSourceUtils.getJdbcUrl((DbType)DbType.SQLSERVER, (ConnectionParam)baseDataSource)).append("\"").append(" ").append("--driver").append(" ").append(DataSourceUtils.getDatasourceDriver((DbType)DbType.SQLSERVER)).append(" ").append("--username").append(" ").append(baseDataSource.getUser()).append(" ").append("--password").append(" ").append("\"").append(PasswordUtils.decodePassword((String)baseDataSource.getPassword())).append("\"");
            if (sourceSqlServerParameter.getSrcQueryType() == SqoopQueryType.FORM.getCode().intValue()) {
                if (StringUtils.isNotEmpty((CharSequence)sourceSqlServerParameter.getSrcTable())) {
                    sqlServerSourceSb.append(" ").append("--table").append(" ").append(sourceSqlServerParameter.getSrcTable());
                }
                if (StringUtils.isNotEmpty((CharSequence)sourceSqlServerParameter.getSrcColumns())) {
                    sqlServerSourceSb.append(" ").append("--columns").append(" ").append(sourceSqlServerParameter.getSrcColumns());
                }
            } else if (sourceSqlServerParameter.getSrcQueryType() == SqoopQueryType.SQL.getCode().intValue() && StringUtils.isNotEmpty((CharSequence)sourceSqlServerParameter.getSrcQuerySql())) {
                String srcQuery = sourceSqlServerParameter.getSrcQuerySql();
                sqlServerSourceSb.append(" ").append("--query").append(" ").append("\"").append(srcQuery);
                if (srcQuery.toLowerCase().contains("where")) {
                    sqlServerSourceSb.append(" ").append("AND \\$CONDITIONS").append("\"");
                } else {
                    sqlServerSourceSb.append(" ").append("WHERE \\$CONDITIONS").append("\"");
                }
            }
            SqlServerSourceGenerator.buildColumnMapToHive(sqlServerSourceSb, sourceSqlServerParameter);
            SqlServerSourceGenerator.buildColumnMapToJava(sqlServerSourceSb, sourceSqlServerParameter);
        }
        catch (Exception e) {
            logger.error(String.format("Sqoop task sqlServer source params build failed: [%s]", e.getMessage()));
        }
        return sqlServerSourceSb.toString();
    }

    private static void buildColumnMapToHive(StringBuilder sqlServerSourceSb, SourceSqlServerParameter sourceSqlServerParameter) {
        List<Property> mapColumnHive = sourceSqlServerParameter.getMapColumnHive();
        if (null != mapColumnHive && !mapColumnHive.isEmpty()) {
            StringBuilder columnMap = new StringBuilder();
            for (Property item : mapColumnHive) {
                columnMap.append(item.getProp()).append("=").append(item.getValue()).append(",");
            }
            if (StringUtils.isNotEmpty((CharSequence)columnMap.toString())) {
                sqlServerSourceSb.append(" ").append("--map-column-hive").append(" ").append(columnMap.substring(0, columnMap.length() - 1));
            }
        }
    }

    private static void buildColumnMapToJava(StringBuilder sqlServerSourceSb, SourceSqlServerParameter sourceSqlServerParameter) {
        List<Property> mapColumnJava = sourceSqlServerParameter.getMapColumnJava();
        if (null != mapColumnJava && !mapColumnJava.isEmpty()) {
            StringBuilder columnMap = new StringBuilder();
            for (Property item : mapColumnJava) {
                columnMap.append(item.getProp()).append("=").append(item.getValue()).append(",");
            }
            if (StringUtils.isNotEmpty((CharSequence)columnMap.toString())) {
                sqlServerSourceSb.append(" ").append("--map-column-java").append(" ").append(columnMap.substring(0, columnMap.length() - 1));
            }
        }
    }
}

