/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.pytorch;

import java.io.File;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.dolphinscheduler.common.shell.AbstractShell;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitProjectManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitProjectManager.class);
    public static final String GIT_PATH_LOCAL = "GIT_PROJECT";
    private static final Pattern GIT_CHECK_PATTERN = Pattern.compile("^(git@|https?://)(?![&|])[^&|]+$");
    private String path;
    private String baseDir = ".";

    public static boolean isGitPath(String path) {
        return GIT_CHECK_PATTERN.matcher(path).matches();
    }

    public void prepareProject() throws Exception {
        block2: {
            String savePath = Paths.get(this.baseDir, GIT_PATH_LOCAL).toString();
            log.info("clone project {} to {}", (Object)this.path, (Object)savePath);
            String[] command = new String[]{"sh", "-c", String.format("git clone %s %s", this.getGitUrl(), savePath)};
            try {
                OSUtils.exeShell((String[])command);
            }
            catch (AbstractShell.ExitCodeException e) {
                if (new File(savePath).exists()) break block2;
                throw e;
            }
        }
        log.info("clone project done");
    }

    public String getGitUrl() {
        String gitUrl = this.path.contains("#") ? this.path.split("#")[0] : this.path;
        return gitUrl;
    }

    public String getGitLocalPath() {
        String gitLocalPath = this.path.contains("#") ? Paths.get(GIT_PATH_LOCAL, this.path.split("#")[1]).toString() : GIT_PATH_LOCAL;
        return Paths.get(this.baseDir, gitLocalPath).toString();
    }

    @Generated
    public GitProjectManager() {
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getBaseDir() {
        return this.baseDir;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitProjectManager)) {
            return false;
        }
        GitProjectManager other = (GitProjectManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$baseDir = this.getBaseDir();
        String other$baseDir = other.getBaseDir();
        return !(this$baseDir == null ? other$baseDir != null : !this$baseDir.equals(other$baseDir));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GitProjectManager;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $baseDir = this.getBaseDir();
        result = result * 59 + ($baseDir == null ? 43 : $baseDir.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GitProjectManager(path=" + this.getPath() + ", baseDir=" + this.getBaseDir() + ")";
    }
}

