/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.procedure;

import com.google.common.collect.Maps;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.plugin.DataSourceClientProvider;
import org.apache.dolphinscheduler.plugin.datasource.api.plugin.DataSourceProcessorProvider;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskConstants;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.DataType;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.procedure.ProcedureParameters;
import org.apache.dolphinscheduler.plugin.task.procedure.ProcedureTaskExecutionContext;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureTask
extends AbstractTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcedureTask.class);
    private final ProcedureParameters procedureParameters;
    private final TaskExecutionContext taskExecutionContext;
    private final ProcedureTaskExecutionContext procedureTaskExecutionContext;

    public ProcedureTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
        this.procedureParameters = (ProcedureParameters)((Object)JSONUtils.parseObject((String)taskExecutionContext.getTaskParams(), ProcedureParameters.class));
        log.info("Initialize procedure task params {}", (Object)JSONUtils.toPrettyJsonString((Object)((Object)this.procedureParameters)));
        if (this.procedureParameters == null || !this.procedureParameters.checkParameters()) {
            throw new TaskException("procedure task params is not valid");
        }
        this.procedureTaskExecutionContext = this.procedureParameters.generateExtendedContext(taskExecutionContext.getResourceParametersHelper());
    }

    public void handle(TaskCallBack taskCallBack) throws TaskException {
        log.info("procedure type : {}, datasource : {}, method : {} , localParams : {}", new Object[]{this.procedureParameters.getType(), this.procedureParameters.getDatasource(), this.procedureParameters.getMethod(), this.procedureParameters.getLocalParams()});
        DbType dbType = DbType.valueOf((String)this.procedureParameters.getType());
        DataSourceProcessor dataSourceProcessor = DataSourceProcessorProvider.getDataSourceProcessor((DbType)dbType);
        ConnectionParam connectionParams = dataSourceProcessor.createConnectionParams(this.procedureTaskExecutionContext.getConnectionParams());
        try (Connection connection = DataSourceClientProvider.getAdHocConnection((DbType)dbType, (ConnectionParam)connectionParams);){
            HashMap paramsMap;
            HashMap<Integer, Property> sqlParamsMap = new HashMap<Integer, Property>();
            Map map = paramsMap = this.taskExecutionContext.getPrepareParamsMap() == null ? Maps.newHashMap() : this.taskExecutionContext.getPrepareParamsMap();
            if (this.procedureParameters.getOutProperty() != null) {
                paramsMap.putAll(this.procedureParameters.getOutProperty());
            }
            String proceduerSql = this.formatSql(sqlParamsMap, paramsMap);
            try (CallableStatement stmt = connection.prepareCall(proceduerSql);){
                this.setTimeout(stmt);
                Map<Integer, Property> outParameterMap = this.getOutParameterMap(stmt, sqlParamsMap, paramsMap);
                stmt.executeUpdate();
                this.printOutParameter(stmt, outParameterMap);
                this.setExitStatusCode(0);
            }
        }
        catch (Exception e) {
            this.setExitStatusCode(-1);
            log.error("procedure task error", (Throwable)e);
            throw new TaskException("Execute procedure task failed", (Throwable)e);
        }
    }

    public void cancel() throws TaskException {
    }

    private String formatSql(Map<Integer, Property> sqlParamsMap, Map<String, Property> paramsMap) {
        this.setSqlParamsMap(this.procedureParameters.getMethod(), sqlParamsMap, paramsMap, this.taskExecutionContext.getTaskInstanceId());
        return this.procedureParameters.getMethod().replaceAll(TaskConstants.SQL_PARAMS_REGEX, "?");
    }

    private void printOutParameter(CallableStatement stmt, Map<Integer, Property> outParameterMap) throws SQLException {
        for (Map.Entry<Integer, Property> en : outParameterMap.entrySet()) {
            int index = en.getKey();
            Property property = en.getValue();
            String prop = property.getProp();
            DataType dataType = property.getType();
            this.procedureParameters.dealOutParam4Procedure(this.getOutputParameter(stmt, index, prop, dataType), prop);
        }
    }

    private Map<Integer, Property> getOutParameterMap(CallableStatement stmt, Map<Integer, Property> paramsMap, Map<String, Property> totalParamsMap) throws Exception {
        HashMap<Integer, Property> outParameterMap = new HashMap<Integer, Property>();
        if (this.procedureParameters.getLocalParametersMap() == null) {
            return outParameterMap;
        }
        int index = 1;
        if (paramsMap != null) {
            for (Map.Entry<Integer, Property> entry : paramsMap.entrySet()) {
                Property property = entry.getValue();
                if (property.getDirect().equals((Object)Direct.IN)) {
                    ParameterUtils.setInParameter((int)index, (PreparedStatement)stmt, (DataType)property.getType(), (String)totalParamsMap.get(property.getProp()).getValue());
                } else if (property.getDirect().equals((Object)Direct.OUT)) {
                    this.setOutParameter(index, stmt, property.getType(), totalParamsMap.get(property.getProp()).getValue());
                    outParameterMap.put(index, property);
                }
                ++index;
            }
        }
        return outParameterMap;
    }

    private void setTimeout(CallableStatement stmt) throws SQLException {
        Boolean failed = this.taskExecutionContext.getTaskTimeoutStrategy() == TaskTimeoutStrategy.FAILED;
        Boolean warnFailed = this.taskExecutionContext.getTaskTimeoutStrategy() == TaskTimeoutStrategy.WARNFAILED;
        if (failed.booleanValue() || warnFailed.booleanValue()) {
            stmt.setQueryTimeout(this.taskExecutionContext.getTaskTimeout());
        }
    }

    private Object getOutputParameter(CallableStatement stmt, int index, String prop, DataType dataType) throws SQLException {
        Object value = null;
        switch (dataType) {
            case VARCHAR: {
                log.info("out prameter varchar key : {} , value : {}", (Object)prop, (Object)stmt.getString(index));
                value = stmt.getString(index);
                break;
            }
            case INTEGER: {
                log.info("out prameter integer key : {} , value : {}", (Object)prop, (Object)stmt.getInt(index));
                value = stmt.getInt(index);
                break;
            }
            case LONG: {
                log.info("out prameter long key : {} , value : {}", (Object)prop, (Object)stmt.getLong(index));
                value = stmt.getLong(index);
                break;
            }
            case FLOAT: {
                log.info("out prameter float key : {} , value : {}", (Object)prop, (Object)Float.valueOf(stmt.getFloat(index)));
                value = Float.valueOf(stmt.getFloat(index));
                break;
            }
            case DOUBLE: {
                log.info("out prameter double key : {} , value : {}", (Object)prop, (Object)stmt.getDouble(index));
                value = stmt.getDouble(index);
                break;
            }
            case DATE: {
                log.info("out prameter date key : {} , value : {}", (Object)prop, (Object)stmt.getDate(index));
                value = stmt.getDate(index);
                break;
            }
            case TIME: {
                log.info("out prameter time key : {} , value : {}", (Object)prop, (Object)stmt.getTime(index));
                value = stmt.getTime(index);
                break;
            }
            case TIMESTAMP: {
                log.info("out prameter timestamp key : {} , value : {}", (Object)prop, (Object)stmt.getTimestamp(index));
                value = stmt.getTimestamp(index);
                break;
            }
            case BOOLEAN: {
                log.info("out prameter boolean key : {} , value : {}", (Object)prop, (Object)stmt.getBoolean(index));
                value = stmt.getBoolean(index);
                break;
            }
        }
        return value;
    }

    public AbstractParameters getParameters() {
        return this.procedureParameters;
    }

    private void setOutParameter(int index, CallableStatement stmt, DataType dataType, String value) throws Exception {
        int sqlType;
        switch (dataType) {
            case VARCHAR: {
                sqlType = 12;
                break;
            }
            case INTEGER: 
            case LONG: {
                sqlType = 4;
                break;
            }
            case FLOAT: {
                sqlType = 6;
                break;
            }
            case DOUBLE: {
                sqlType = 8;
                break;
            }
            case DATE: {
                sqlType = 91;
                break;
            }
            case TIME: {
                sqlType = 92;
                break;
            }
            case TIMESTAMP: {
                sqlType = 93;
                break;
            }
            case BOOLEAN: {
                sqlType = 16;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + dataType);
            }
        }
        if (StringUtils.isEmpty((CharSequence)value)) {
            stmt.registerOutParameter(index, sqlType);
        } else {
            stmt.registerOutParameter(index, sqlType, value);
        }
    }
}

