/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.http;

import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.model.OkHttpRequestHeaderContentType;
import org.apache.dolphinscheduler.common.model.OkHttpRequestHeaders;
import org.apache.dolphinscheduler.common.model.OkHttpResponse;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.OkHttpUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.DataType;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.http.HttpCheckCondition;
import org.apache.dolphinscheduler.plugin.task.http.HttpParameters;
import org.apache.dolphinscheduler.plugin.task.http.HttpParametersType;
import org.apache.dolphinscheduler.plugin.task.http.HttpProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTask
extends AbstractTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpTask.class);
    private HttpParameters httpParameters;
    private TaskExecutionContext taskExecutionContext;

    public HttpTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public void init() {
        this.httpParameters = (HttpParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), HttpParameters.class));
        log.info("Initialize http task params: {}", (Object)JSONUtils.toPrettyJsonString((Object)((Object)this.httpParameters)));
        if (this.httpParameters == null || !this.httpParameters.checkParameters()) {
            throw new RuntimeException("http task params is not valid");
        }
    }

    public void handle(TaskCallBack taskCallBack) throws TaskException {
        OkHttpResponse httpResponse = this.sendRequest();
        this.validateResponse(httpResponse.getBody(), httpResponse.getStatusCode());
    }

    public void cancel() throws TaskException {
    }

    private void validateResponse(String body, int statusCode) {
        switch (this.httpParameters.getHttpCheckCondition()) {
            case BODY_CONTAINS: {
                if (!StringUtils.isEmpty((CharSequence)body) && body.contains(this.httpParameters.getCondition())) break;
                log.error("http request failed, url: {}, statusCode: {}, checkCondition: {}, body: {}", new Object[]{this.httpParameters.getUrl(), statusCode, HttpCheckCondition.BODY_CONTAINS.name(), body});
                this.exitStatusCode = -1;
                return;
            }
            case BODY_NOT_CONTAINS: {
                if (!StringUtils.isEmpty((CharSequence)body) && !body.contains(this.httpParameters.getCondition())) break;
                log.error("http request failed, url: {}, statusCode: {}, checkCondition: {}, body: {}", new Object[]{this.httpParameters.getUrl(), statusCode, HttpCheckCondition.BODY_NOT_CONTAINS.name(), body});
                this.exitStatusCode = -1;
                return;
            }
            case STATUS_CODE_CUSTOM: {
                if (statusCode == Integer.parseInt(this.httpParameters.getCondition())) break;
                log.error("http request failed, url: {}, statusCode: {}, checkCondition: {}, body: {}", new Object[]{this.httpParameters.getUrl(), statusCode, HttpCheckCondition.STATUS_CODE_CUSTOM.name(), body});
                this.exitStatusCode = -1;
                return;
            }
            case STATUS_CODE_DEFAULT: {
                if (200 == statusCode) break;
                log.error("http request failed, url: {}, statusCode: {}, checkCondition: {}, body: {}", new Object[]{this.httpParameters.getUrl(), statusCode, HttpCheckCondition.STATUS_CODE_DEFAULT.name(), body});
                this.exitStatusCode = -1;
                return;
            }
            default: {
                throw new TaskException(String.format("http check condition %s not supported", new Object[]{this.httpParameters.getHttpCheckCondition()}));
            }
        }
        log.info("http request success, url: {}, statusCode: {}, body: {}", new Object[]{this.httpParameters.getUrl(), statusCode, body});
        this.exitStatusCode = 0;
    }

    private OkHttpResponse sendRequest() {
        switch (this.httpParameters.getHttpRequestMethod()) {
            case GET: {
                return this.sendGetRequest();
            }
            case POST: {
                return this.sendPostRequest();
            }
            case PUT: {
                return this.sendPutRequest();
            }
            case DELETE: {
                return this.sendDeleteRequest();
            }
        }
        throw new TaskException(String.format("http request method %s not supported", new Object[]{this.httpParameters.getHttpRequestMethod()}));
    }

    private OkHttpResponse sendGetRequest() {
        OkHttpRequestHeaders okHttpRequestHeaders = new OkHttpRequestHeaders();
        okHttpRequestHeaders.setHeaders(this.getHeaders());
        okHttpRequestHeaders.setOkHttpRequestHeaderContentType(this.getContentType());
        Map<String, Object> requestParams = this.getRequestParams();
        OkHttpResponse okHttpResponse = OkHttpUtils.get((String)this.httpParameters.getUrl(), (OkHttpRequestHeaders)okHttpRequestHeaders, requestParams, (int)this.httpParameters.getConnectTimeout(), (int)this.httpParameters.getConnectTimeout(), (int)this.httpParameters.getConnectTimeout());
        this.addDefaultOutput(JSONUtils.toJsonString((Object)okHttpResponse));
        return okHttpResponse;
    }

    private OkHttpResponse sendPostRequest() {
        OkHttpRequestHeaders okHttpRequestHeaders = new OkHttpRequestHeaders();
        okHttpRequestHeaders.setHeaders(this.getHeaders());
        okHttpRequestHeaders.setOkHttpRequestHeaderContentType(this.getContentType());
        Map<String, Object> requestBody = this.getRequestBody();
        OkHttpResponse okHttpResponse = OkHttpUtils.post((String)this.httpParameters.getUrl(), (OkHttpRequestHeaders)okHttpRequestHeaders, null, requestBody, (int)this.httpParameters.getConnectTimeout(), (int)this.httpParameters.getConnectTimeout(), (int)this.httpParameters.getConnectTimeout());
        this.addDefaultOutput(JSONUtils.toJsonString((Object)okHttpResponse));
        return okHttpResponse;
    }

    private OkHttpResponse sendPutRequest() {
        OkHttpRequestHeaders okHttpRequestHeaders = new OkHttpRequestHeaders();
        okHttpRequestHeaders.setHeaders(this.getHeaders());
        okHttpRequestHeaders.setOkHttpRequestHeaderContentType(this.getContentType());
        Map<String, Object> requestBody = this.getRequestBody();
        OkHttpResponse okHttpResponse = OkHttpUtils.put((String)this.httpParameters.getUrl(), (OkHttpRequestHeaders)okHttpRequestHeaders, requestBody, (int)this.httpParameters.getConnectTimeout(), (int)this.httpParameters.getConnectTimeout(), (int)this.httpParameters.getConnectTimeout());
        this.addDefaultOutput(JSONUtils.toJsonString((Object)okHttpResponse));
        return okHttpResponse;
    }

    private OkHttpResponse sendDeleteRequest() {
        OkHttpRequestHeaders okHttpRequestHeaders = new OkHttpRequestHeaders();
        okHttpRequestHeaders.setHeaders(this.getHeaders());
        okHttpRequestHeaders.setOkHttpRequestHeaderContentType(this.getContentType());
        OkHttpResponse okHttpResponse = OkHttpUtils.delete((String)this.httpParameters.getUrl(), (OkHttpRequestHeaders)okHttpRequestHeaders, (int)this.httpParameters.getConnectTimeout(), (int)this.httpParameters.getConnectTimeout(), (int)this.httpParameters.getConnectTimeout());
        this.addDefaultOutput(JSONUtils.toJsonString((Object)okHttpResponse));
        return okHttpResponse;
    }

    private Map<String, String> getHeaders() {
        if (this.httpParameters.getHttpRequestParams() == null) {
            return null;
        }
        return this.httpParameters.getHttpRequestParams().stream().filter(httpProperty -> httpProperty.getHttpParametersType() != null).filter(httpProperty -> httpProperty.getHttpParametersType().equals((Object)HttpParametersType.HEADERS) && !httpProperty.getProp().equalsIgnoreCase("Content-Type")).peek(httpProperty -> {
            httpProperty.setProp(ParameterUtils.convertParameterPlaceholders((String)httpProperty.getProp(), (Map)ParameterUtils.convert((Map)this.taskExecutionContext.getPrepareParamsMap())));
            httpProperty.setValue(ParameterUtils.convertParameterPlaceholders((String)httpProperty.getValue(), (Map)ParameterUtils.convert((Map)this.taskExecutionContext.getPrepareParamsMap())));
        }).collect(Collectors.toMap(HttpProperty::getProp, HttpProperty::getValue));
    }

    private OkHttpRequestHeaderContentType getContentType() {
        if (this.httpParameters.getHttpRequestParams() == null) {
            return OkHttpRequestHeaderContentType.APPLICATION_JSON;
        }
        return OkHttpRequestHeaderContentType.fromValue((String)this.httpParameters.getHttpRequestParams().stream().filter(httpProperty -> httpProperty.getHttpParametersType().equals((Object)HttpParametersType.HEADERS) && httpProperty.getProp().equalsIgnoreCase("Content-Type")).filter(httpProperty -> OkHttpRequestHeaderContentType.fromValue((String)httpProperty.getValue()) != null).findFirst().orElse(HttpProperty.builder().value(OkHttpRequestHeaderContentType.APPLICATION_JSON.getValue()).build()).getValue());
    }

    private Map<String, Object> getRequestParams() {
        if (this.httpParameters.getHttpRequestParams() == null) {
            return null;
        }
        return this.httpParameters.getHttpRequestParams().stream().filter(httpProperty -> httpProperty.getHttpParametersType().equals((Object)HttpParametersType.PARAMETER)).peek(httpProperty -> {
            httpProperty.setProp(ParameterUtils.convertParameterPlaceholders((String)httpProperty.getProp(), (Map)ParameterUtils.convert((Map)this.taskExecutionContext.getPrepareParamsMap())));
            httpProperty.setValue(ParameterUtils.convertParameterPlaceholders((String)httpProperty.getValue(), (Map)ParameterUtils.convert((Map)this.taskExecutionContext.getPrepareParamsMap())));
        }).collect(Collectors.toMap(HttpProperty::getProp, HttpProperty::getValue));
    }

    private Map<String, Object> getRequestBody() {
        String convertedParams = ParameterUtils.convertParameterPlaceholders((String)this.httpParameters.getHttpRequestBody(), (Map)ParameterUtils.convert((Map)this.taskExecutionContext.getPrepareParamsMap()));
        Map requestBody = JSONUtils.toMap((String)convertedParams);
        if (requestBody == null) {
            return null;
        }
        return requestBody.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public AbstractParameters getParameters() {
        return this.httpParameters;
    }

    public void addDefaultOutput(String response) {
        Property outputProperty = new Property();
        outputProperty.setProp(String.format("%s.%s", this.taskExecutionContext.getTaskName(), "response"));
        outputProperty.setDirect(Direct.OUT);
        outputProperty.setType(DataType.VARCHAR);
        outputProperty.setValue(response);
        this.httpParameters.addPropertyToValPool(outputProperty);
    }
}

