/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.emr;

import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduce;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.util.Map;
import lombok.Generated;
import org.apache.dolphinscheduler.authentication.aws.AmazonElasticMapReduceClientFactory;
import org.apache.dolphinscheduler.common.constants.SystemConstants;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractRemoteTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.emr.EmrParameters;
import org.apache.dolphinscheduler.plugin.task.emr.EmrTaskException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEmrTask
extends AbstractRemoteTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractEmrTask.class);
    final TaskExecutionContext taskExecutionContext;
    EmrParameters emrParameters;
    AmazonElasticMapReduce emrClient;
    String clusterId;
    static final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true).configure(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS, true).setTimeZone(SystemConstants.DEFAULT_TIME_ZONE).setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategy.UpperCamelCaseStrategy());

    protected AbstractEmrTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public void init() {
        String taskParams = this.taskExecutionContext.getTaskParams();
        this.emrParameters = (EmrParameters)((Object)JSONUtils.parseObject((String)taskParams, EmrParameters.class));
        log.info("Initialize emr task params:{}", (Object)JSONUtils.toPrettyJsonString((Object)taskParams));
        if (this.emrParameters == null || !this.emrParameters.checkParameters()) {
            throw new EmrTaskException("emr task params is not valid");
        }
        this.emrClient = this.createEmrClient();
    }

    public AbstractParameters getParameters() {
        return this.emrParameters;
    }

    protected AmazonElasticMapReduce createEmrClient() {
        Map awsProperties = PropertyUtils.getByPrefix((String)"aws.emr.", (String)"");
        return AmazonElasticMapReduceClientFactory.createAmazonElasticMapReduceClient((Map)awsProperties);
    }
}

