/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.dinky;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractRemoteTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parser.PlaceholderUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.dinky.DinkyParameters;
import org.apache.dolphinscheduler.plugin.task.dinky.DinkyTaskException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DinkyTask
extends AbstractRemoteTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DinkyTask.class);
    private final TaskExecutionContext taskExecutionContext;
    private DinkyParameters dinkyParameters;
    private String jobInstanceId;
    private boolean status;
    private String dinkyVersion;

    protected DinkyTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public List<String> getApplicationIds() throws TaskException {
        return Collections.emptyList();
    }

    public void init() {
        String taskParams = this.taskExecutionContext.getTaskParams();
        this.dinkyParameters = (DinkyParameters)((Object)JSONUtils.parseObject((String)taskParams, DinkyParameters.class));
        log.info("Initialize dinky task params: {}", (Object)JSONUtils.toPrettyJsonString((Object)((Object)this.dinkyParameters)));
        if (this.dinkyParameters == null || !this.dinkyParameters.checkParameters()) {
            throw new DinkyTaskException("dinky task params is not valid");
        }
    }

    public void handle(TaskCallBack taskCallBack) throws TaskException {
        this.dinkyVersion = this.getDinkyVersion(this.dinkyParameters.getAddress());
        super.handle(taskCallBack);
    }

    public void submitApplication() throws TaskException {
        if (this.dinkyVersion.startsWith("0")) {
            this.submitApplicationV0();
        } else {
            this.submitApplicationV1();
        }
    }

    public void trackApplicationStatus() throws TaskException {
        if (this.dinkyVersion.startsWith("0")) {
            this.trackApplicationStatusV0();
        } else {
            this.trackApplicationStatusV1();
        }
    }

    private void submitApplicationV0() {
        try {
            String address = this.dinkyParameters.getAddress();
            String taskId = this.dinkyParameters.getTaskId();
            boolean isOnline = this.dinkyParameters.isOnline();
            String apiResultDatasKey = "datas";
            JsonNode result = isOnline ? this.onlineTaskV0(address, taskId) : this.submitTaskV0(address, taskId);
            if (this.checkResultV0(result)) {
                this.status = result.get(apiResultDatasKey).get("success").asBoolean();
                if (result.get(apiResultDatasKey).has("jobInstanceId") && !(result.get(apiResultDatasKey).get("jobInstanceId") instanceof NullNode)) {
                    this.jobInstanceId = result.get(apiResultDatasKey).get("jobInstanceId").asText();
                }
            }
        }
        catch (Exception ex) {
            Thread.currentThread().interrupt();
            log.error("Submit dinkyTask failed:", (Throwable)ex);
            this.setExitStatusCode(-1);
            throw new TaskException("Submit dinkyTask failed:", (Throwable)ex);
        }
    }

    private void submitApplicationV1() {
        block4: {
            try {
                String address = this.dinkyParameters.getAddress();
                String taskId = this.dinkyParameters.getTaskId();
                boolean isOnline = this.dinkyParameters.isOnline();
                String apiResultDataKey = "data";
                JsonNode result = this.submitTaskV1(address, taskId, isOnline, this.generateVariables());
                if (this.checkResultV1(result)) {
                    this.status = result.get("success").asBoolean();
                    if (result.get(apiResultDataKey).has("jobInstanceId") && !(result.get(apiResultDataKey).get("jobInstanceId") instanceof NullNode)) {
                        this.jobInstanceId = result.get(apiResultDataKey).get("jobInstanceId").asText();
                    }
                    break block4;
                }
                log.error("Submit dinkyTask failed:{}", (Object)result.get("msg"));
                this.setExitStatusCode(-1);
                throw new TaskException("Submit dinkyTask failed:" + result.get("msg"));
            }
            catch (Exception ex) {
                Thread.currentThread().interrupt();
                log.error("Submit dinkyTask failed:", (Throwable)ex);
                this.setExitStatusCode(-1);
                throw new TaskException("Submit dinkyTask failed:", (Throwable)ex);
            }
        }
    }

    public void trackApplicationStatusV0() throws TaskException {
        try {
            JsonNode jobInstanceInfoResult;
            String address = this.dinkyParameters.getAddress();
            String taskId = this.dinkyParameters.getTaskId();
            if (this.status && this.jobInstanceId == null) {
                this.setAppIds(String.format("%s-%s", address, taskId));
                this.setExitStatusCode(this.mapStatusToExitCode(true));
                log.info("Dinky common sql task finished.");
                return;
            }
            String apiResultDatasKey = "datas";
            boolean finishFlag = false;
            block12: while (!finishFlag && this.checkResultV0(jobInstanceInfoResult = this.getJobInstanceInfo(address, this.jobInstanceId))) {
                String jobInstanceStatus;
                switch (jobInstanceStatus = jobInstanceInfoResult.get(apiResultDatasKey).get("status").asText()) {
                    case "FINISHED": {
                        int exitStatusCode = this.mapStatusToExitCode(this.status);
                        this.setAppIds(String.format("%s-%s", address, taskId));
                        this.setExitStatusCode(exitStatusCode);
                        log.info("dinky task finished with results: {}", (Object)jobInstanceInfoResult.get(apiResultDatasKey));
                        finishFlag = true;
                        continue block12;
                    }
                    case "FAILED": 
                    case "CANCELED": 
                    case "UNKNOWN": {
                        this.errorHandle(jobInstanceInfoResult.get(apiResultDatasKey).get("error").asText());
                        finishFlag = true;
                        continue block12;
                    }
                }
                Thread.sleep(3000L);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            log.error("Track dinkyTask failed:", (Throwable)ex);
            this.setExitStatusCode(-1);
            throw new TaskException("Track dinkyTask failed:", (Throwable)ex);
        }
    }

    public void trackApplicationStatusV1() throws TaskException {
        try {
            JsonNode jobInstanceInfoResult;
            String address = this.dinkyParameters.getAddress();
            String taskId = this.dinkyParameters.getTaskId();
            if (this.status && this.jobInstanceId == null) {
                this.setAppIds(String.format("%s-%s", address, taskId));
                this.setExitStatusCode(this.mapStatusToExitCode(true));
                log.info("Dinky common sql task finished.");
                return;
            }
            String apiResultDataKey = "data";
            boolean finishFlag = false;
            block12: while (!finishFlag && this.checkResultV1(jobInstanceInfoResult = this.getJobInstanceInfo(address, this.jobInstanceId))) {
                String jobInstanceStatus;
                switch (jobInstanceStatus = jobInstanceInfoResult.get(apiResultDataKey).get("status").asText()) {
                    case "FINISHED": {
                        int exitStatusCode = this.mapStatusToExitCode(this.status);
                        this.setAppIds(String.format("%s-%s", address, taskId));
                        this.setExitStatusCode(exitStatusCode);
                        log.info("dinky task finished with results: {}", (Object)jobInstanceInfoResult.get(apiResultDataKey));
                        finishFlag = true;
                        continue block12;
                    }
                    case "FAILED": 
                    case "CANCELED": 
                    case "UNKNOWN": {
                        this.errorHandle(jobInstanceInfoResult.get(apiResultDataKey).get("error").asText());
                        finishFlag = true;
                        continue block12;
                    }
                }
                Thread.sleep(3000L);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            log.error("Track dinkyTask failed:", (Throwable)ex);
            this.setExitStatusCode(-1);
            throw new TaskException("Track dinkyTask failed:", (Throwable)ex);
        }
    }

    private int mapStatusToExitCode(boolean status) {
        if (status) {
            return 0;
        }
        return -1;
    }

    private boolean checkResultV0(JsonNode result) {
        boolean isCorrect = true;
        if (result instanceof MissingNode || result instanceof NullNode) {
            this.errorHandle("Please check that the dinky version is greater than or equal to 0.6.5");
            isCorrect = false;
        } else if (result.get("code").asInt() == 1) {
            this.errorHandle(result.get("msg"));
            isCorrect = false;
        }
        return isCorrect;
    }

    private boolean checkResultV1(JsonNode result) {
        boolean isCorrect = true;
        if (result instanceof MissingNode || result instanceof NullNode) {
            this.errorHandle("Please check that the dinky version is greater than or equal to 0.6.5");
            isCorrect = false;
        } else if (!result.get("success").asBoolean()) {
            this.errorHandle(result.get("msg"));
            isCorrect = false;
        }
        return isCorrect;
    }

    private void errorHandle(Object msg) {
        this.setExitStatusCode(-1);
        log.error("dinky task submit failed with error: {}", msg);
    }

    public AbstractParameters getParameters() {
        return this.dinkyParameters;
    }

    public void cancelApplication() throws TaskException {
        String address = this.dinkyParameters.getAddress();
        String taskId = this.dinkyParameters.getTaskId();
        log.info("trying terminate dinky task, taskId: {}, address: {}, taskId: {}", new Object[]{this.taskExecutionContext.getTaskInstanceId(), address, taskId});
        this.cancelTask(address, taskId);
        log.warn("dinky task terminated, taskId: {}, address: {}, taskId: {}", new Object[]{this.taskExecutionContext.getTaskInstanceId(), address, taskId});
    }

    private Map<String, String> generateVariables() {
        ConcurrentHashMap<String, String> variables = new ConcurrentHashMap<String, String>();
        List propertyList = JSONUtils.toList((String)this.taskExecutionContext.getGlobalParams(), Property.class);
        if (propertyList != null && !propertyList.isEmpty()) {
            for (Property property : propertyList) {
                variables.put(property.getProp(), property.getValue());
            }
        }
        List localParams = this.dinkyParameters.getLocalParams();
        Map prepareParamsMap = this.taskExecutionContext.getPrepareParamsMap();
        if (localParams == null || localParams.isEmpty()) {
            return variables;
        }
        Map convertMap = ParameterUtils.convert((Map)prepareParamsMap);
        for (Property property : localParams) {
            String propertyValue = property.getValue();
            String value = PlaceholderUtils.replacePlaceholders((String)propertyValue, (Map)convertMap, (boolean)true);
            variables.put(property.getProp(), value);
        }
        return variables;
    }

    private String getDinkyVersion(String address) {
        JsonNode versionJsonNode = this.parse(this.doGet(address + "/openapi/version", new HashMap<String, String>()));
        if (versionJsonNode instanceof MissingNode || versionJsonNode == null || versionJsonNode.get("code").asInt() == 1) {
            return "0";
        }
        return versionJsonNode.get("data").asText();
    }

    private JsonNode submitTaskV0(String address, String taskId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", taskId);
        return this.parse(this.doGet(address + "/openapi/submitTask", params));
    }

    private JsonNode onlineTaskV0(String address, String taskId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", taskId);
        return this.parse(this.doGet(address + "/openapi/onLineTask", params));
    }

    private JsonNode submitTaskV1(String address, String taskId, boolean isOnline, Map<String, String> variables) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", taskId);
        params.put("isOnline", isOnline);
        params.put("variables", variables);
        return this.parse(this.sendJsonStr(address + "/openapi/submitTask", JSONUtils.toJsonString(params)));
    }

    private JsonNode cancelTask(String address, String taskId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskId", taskId);
        params.put("type", "cancel");
        return this.parse(this.sendJsonStr(address + "/openapi/savepointTask", JSONUtils.toJsonString(params)));
    }

    private JsonNode getJobInstanceInfo(String address, String taskId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", taskId);
        return this.parse(this.doGet(address + "/openapi/getJobInstance", params));
    }

    private JsonNode parse(String res) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode result = null;
        try {
            result = mapper.readTree(res);
        }
        catch (JsonProcessingException e) {
            log.error("dinky task submit failed with error", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doGet(String url, Map<String, String> params) {
        String result = "";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet httpGet = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            if (null != params && !params.isEmpty()) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    uriBuilder.addParameter(entry.getKey(), entry.getValue());
                }
            }
            URI uri = uriBuilder.build();
            httpGet = new HttpGet(uri);
            log.info("access url: {}", (Object)uri);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                result = EntityUtils.toString((HttpEntity)response.getEntity());
                log.info("dinky task succeed with results: {}", (Object)result);
            } else {
                log.error("dinky task terminated,response: {}", (Object)response);
            }
        }
        catch (IllegalArgumentException ie) {
            log.error("dinky task terminated: {}", (Object)ie.getMessage());
        }
        catch (Exception e) {
            log.error("dinky task terminated: ", (Throwable)e);
        }
        finally {
            if (null != httpGet) {
                httpGet.releaseConnection();
            }
        }
        return result;
    }

    private String sendJsonStr(String url, String params) {
        String result = "";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url);
        try {
            HttpResponse response;
            httpPost.addHeader("Content-type", "application/json; charset=utf-8");
            httpPost.setHeader("Accept", "application/json");
            if (StringUtils.isNotBlank((CharSequence)params)) {
                httpPost.setEntity((HttpEntity)new StringEntity(params, StandardCharsets.UTF_8));
            }
            if ((response = httpClient.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() == 200) {
                result = EntityUtils.toString((HttpEntity)response.getEntity());
                log.info("dinky task succeed with results: {}", (Object)result);
            } else {
                log.error("dinky task terminated,response: {}", (Object)response);
            }
        }
        catch (IllegalArgumentException ie) {
            log.error("dinky task terminated: {}", (Object)ie.getMessage());
        }
        catch (Exception he) {
            log.error("dinky task terminated: ", (Throwable)he);
        }
        return result;
    }
}

