/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.datasync;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractRemoteTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.datasync.DatasyncHook;
import org.apache.dolphinscheduler.plugin.task.datasync.DatasyncParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.datasync.model.TaskExecutionStatus;

public class DatasyncTask
extends AbstractRemoteTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatasyncTask.class);
    private static final ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true)).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true)).configure(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS, true)).propertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategies.UpperCamelCaseStrategy())).build();
    private final TaskExecutionContext taskExecutionContext;
    private DatasyncParameters parameters;
    private DatasyncHook hook;

    public DatasyncTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public List<String> getApplicationIds() throws TaskException {
        return Collections.emptyList();
    }

    public void init() {
        this.parameters = (DatasyncParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), DatasyncParameters.class));
        log.info("Initialize Datasync task params {}", (Object)JSONUtils.toPrettyJsonString((Object)((Object)this.parameters)));
        this.initParams();
        this.hook = new DatasyncHook();
    }

    public void initParams() throws TaskException {
        if (this.parameters.isJsonFormat() && StringUtils.isNotEmpty((CharSequence)this.parameters.getJson())) {
            try {
                this.parameters = (DatasyncParameters)((Object)objectMapper.readValue(this.parameters.getJson(), DatasyncParameters.class));
            }
            catch (JsonProcessingException e) {
                throw new TaskException("Convert json to task params failed", (Throwable)e);
            }
            log.info("Success convert json to task params {}", (Object)JSONUtils.toPrettyJsonString((Object)((Object)this.parameters)));
        }
    }

    public void submitApplication() throws TaskException {
        try {
            int exitStatusCode = this.checkCreateTask();
            if (exitStatusCode == -1) {
                this.setExitStatusCode(exitStatusCode);
                return;
            }
            exitStatusCode = this.startDatasyncTask();
            this.setExitStatusCode(exitStatusCode);
        }
        catch (Exception e) {
            this.setExitStatusCode(-1);
            throw new TaskException("datasync task error", (Throwable)e);
        }
        this.setAppIds(this.hook.getTaskExecArn());
    }

    public void cancelApplication() throws TaskException {
        this.checkApplicationId();
        this.hook.cancelDatasyncTask();
    }

    public void trackApplicationStatus() throws TaskException {
        this.checkApplicationId();
        Boolean isFinishedSuccessfully = null;
        isFinishedSuccessfully = this.hook.doubleCheckFinishStatus(TaskExecutionStatus.SUCCESS, DatasyncHook.doneStatus);
        this.exitStatusCode = isFinishedSuccessfully == false ? -1 : 0;
    }

    private void checkApplicationId() {
        String taskExecArn = this.hook.getTaskExecArn();
        if (StringUtils.isEmpty((CharSequence)taskExecArn)) {
            if (StringUtils.isEmpty((CharSequence)this.getAppIds())) {
                throw new TaskException("datasync taskExecArn is null, not created yet");
            }
            this.hook.setTaskExecArn(this.getAppIds());
        }
    }

    public int checkCreateTask() {
        Boolean isCreateSuccessfully = this.hook.createDatasyncTask(this.parameters);
        if (!isCreateSuccessfully.booleanValue()) {
            return -1;
        }
        return 0;
    }

    public int startDatasyncTask() {
        Boolean isStartSuccessfully = this.hook.startDatasyncTask();
        if (!isStartSuccessfully.booleanValue()) {
            return -1;
        }
        return 0;
    }

    public DatasyncParameters getParameters() {
        return this.parameters;
    }

    @Generated
    public void setParameters(DatasyncParameters parameters) {
        this.parameters = parameters;
    }

    @Generated
    public void setHook(DatasyncHook hook) {
        this.hook = hook;
    }
}

