/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.datafactory;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractRemoteTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.datafactory.DatafactoryHook;
import org.apache.dolphinscheduler.plugin.task.datafactory.DatafactoryParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatafactoryTask
extends AbstractRemoteTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatafactoryTask.class);
    private final TaskExecutionContext taskExecutionContext;
    private DatafactoryParameters parameters;
    private DatafactoryHook hook;

    public DatafactoryTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public List<String> getApplicationIds() throws TaskException {
        return Collections.emptyList();
    }

    public void init() {
        this.parameters = (DatafactoryParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), DatafactoryParameters.class));
        log.info("Initialize Datafactory task params {}", (Object)JSONUtils.toPrettyJsonString((Object)((Object)this.parameters)));
        this.hook = new DatafactoryHook();
    }

    public void submitApplication() throws TaskException {
        try {
            this.exitStatusCode = this.startDatafactoryTask();
            this.setExitStatusCode(this.exitStatusCode);
        }
        catch (Exception e) {
            this.setExitStatusCode(-1);
            throw new TaskException("data factory start task error", (Throwable)e);
        }
        this.setAppIds(this.parameters.getRunId());
    }

    public void cancelApplication() throws TaskException {
        this.checkApplicationId();
        this.hook.cancelDatafactoryTask(this.parameters);
        this.exitStatusCode = 137;
    }

    public void trackApplicationStatus() throws TaskException {
        this.checkApplicationId();
        Boolean isFinishedSuccessfully = this.hook.queryStatus(this.parameters);
        this.exitStatusCode = isFinishedSuccessfully == false ? -1 : 0;
    }

    private void checkApplicationId() {
        String taskExecArn = this.hook.getRunId();
        if (StringUtils.isEmpty((CharSequence)taskExecArn)) {
            if (StringUtils.isEmpty((CharSequence)this.getAppIds())) {
                throw new TaskException("datafactory runId is null, not created yet");
            }
            this.hook.setRunId(this.getAppIds());
        }
    }

    public int startDatafactoryTask() {
        Boolean isStartSuccessfully = this.hook.startDatafactoryTask(this.parameters);
        if (!isStartSuccessfully.booleanValue()) {
            return -1;
        }
        return 0;
    }

    public DatafactoryParameters getParameters() {
        return this.parameters;
    }

    @Generated
    public void setParameters(DatafactoryParameters parameters) {
        this.parameters = parameters;
    }

    @Generated
    public void setHook(DatafactoryHook hook) {
        this.hook = hook;
    }

    @Generated
    public TaskExecutionContext getTaskExecutionContext() {
        return this.taskExecutionContext;
    }

    @Generated
    public DatafactoryHook getHook() {
        return this.hook;
    }
}

