/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.enums.dp;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum CheckType {
    COMPARISON_MINUS_STATISTICS(0, "comparison_minus_statistics"),
    STATISTICS_MINUS_COMPARISON(1, "statistics_minus_comparison"),
    STATISTICS_COMPARISON_PERCENTAGE(2, "statistics_comparison_percentage"),
    STATISTICS_COMPARISON_DIFFERENCE_COMPARISON_PERCENTAGE(3, "statistics_comparison_difference_comparison_percentage");

    private final int code;
    private final String description;
    private static final Map<Integer, CheckType> VALUES_MAP;

    private CheckType(int code, String description) {
        this.code = code;
        this.description = description;
    }

    @JsonValue
    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static CheckType of(Integer status) {
        if (VALUES_MAP.containsKey(status)) {
            return VALUES_MAP.get(status);
        }
        throw new IllegalArgumentException("invalid code : " + status);
    }

    static {
        VALUES_MAP = new HashMap<Integer, CheckType>();
        for (CheckType type : CheckType.values()) {
            VALUES_MAP.put(type.code, type);
        }
    }
}

