/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor.queue;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.netty.channel.Channel;
import java.util.Date;
import org.apache.dolphinscheduler.common.enums.Event;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;

public class TaskResponseEvent {
    private int taskInstanceId;
    private String workerAddress;
    private ExecutionStatus state;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date startTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date endTime;
    private String executePath;
    private String logPath;
    private int processId;
    private String appIds;
    private Event event;
    private String varPool;
    private Channel channel;
    private int processInstanceId;
    private long opaque;

    public static TaskResponseEvent newActionStop(ExecutionStatus state, int taskInstanceId, int processInstanceId) {
        TaskResponseEvent event = new TaskResponseEvent();
        event.setState(state);
        event.setTaskInstanceId(taskInstanceId);
        event.setEvent(Event.ACTION_STOP);
        event.setProcessInstanceId(processInstanceId);
        return event;
    }

    public static TaskResponseEvent newAck(ExecutionStatus state, Date startTime, String workerAddress, String executePath, String logPath, int taskInstanceId, Channel channel, int processInstanceId) {
        TaskResponseEvent event = new TaskResponseEvent();
        event.setState(state);
        event.setStartTime(startTime);
        event.setWorkerAddress(workerAddress);
        event.setExecutePath(executePath);
        event.setLogPath(logPath);
        event.setTaskInstanceId(taskInstanceId);
        event.setEvent(Event.ACK);
        event.setChannel(channel);
        event.setProcessInstanceId(processInstanceId);
        return event;
    }

    public static TaskResponseEvent newResult(ExecutionStatus state, Date endTime, int processId, String appIds, int taskInstanceId, String varPool, Channel channel, int processInstanceId) {
        TaskResponseEvent event = new TaskResponseEvent();
        event.setState(state);
        event.setEndTime(endTime);
        event.setProcessId(processId);
        event.setAppIds(appIds);
        event.setTaskInstanceId(taskInstanceId);
        event.setEvent(Event.RESULT);
        event.setVarPool(varPool);
        event.setChannel(channel);
        event.setProcessInstanceId(processInstanceId);
        return event;
    }

    public static TaskResponseEvent newRecall(ExecutionStatus state, Event event, int taskInstanceId, int processInstanceId, Channel channel, long opaque) {
        TaskResponseEvent responseEvent = new TaskResponseEvent();
        responseEvent.setEvent(event);
        responseEvent.setState(state);
        responseEvent.setTaskInstanceId(taskInstanceId);
        responseEvent.setProcessInstanceId(processInstanceId);
        responseEvent.setChannel(channel);
        responseEvent.setOpaque(opaque);
        return responseEvent;
    }

    public String getVarPool() {
        return this.varPool;
    }

    public void setVarPool(String varPool) {
        this.varPool = varPool;
    }

    public int getTaskInstanceId() {
        return this.taskInstanceId;
    }

    public void setTaskInstanceId(int taskInstanceId) {
        this.taskInstanceId = taskInstanceId;
    }

    public String getWorkerAddress() {
        return this.workerAddress;
    }

    public void setWorkerAddress(String workerAddress) {
        this.workerAddress = workerAddress;
    }

    public ExecutionStatus getState() {
        return this.state;
    }

    public void setState(ExecutionStatus state) {
        this.state = state;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getExecutePath() {
        return this.executePath;
    }

    public void setExecutePath(String executePath) {
        this.executePath = executePath;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public int getProcessId() {
        return this.processId;
    }

    public void setProcessId(int processId) {
        this.processId = processId;
    }

    public String getAppIds() {
        return this.appIds;
    }

    public void setAppIds(String appIds) {
        this.appIds = appIds;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public int getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(int processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public long getOpaque() {
        return this.opaque;
    }

    public void setOpaque(long opaque) {
        this.opaque = opaque;
    }
}

