/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.log;

import io.netty.channel.Channel;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.LoggerUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.log.GetLogBytesRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.GetLogBytesResponseCommand;
import org.apache.dolphinscheduler.remote.command.log.RemoveTaskLogRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.RemoveTaskLogResponseCommand;
import org.apache.dolphinscheduler.remote.command.log.RollViewLogRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.RollViewLogResponseCommand;
import org.apache.dolphinscheduler.remote.command.log.ViewLogRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.ViewLogResponseCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.remote.utils.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerRequestProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(LoggerRequestProcessor.class);
    private final ExecutorService executor = Executors.newFixedThreadPool(Constants.CPUS * 2 + 1);

    public void process(Channel channel, Command command) {
        this.logger.info("received command : {}", (Object)command);
        CommandType commandType = command.getType();
        switch (commandType) {
            case GET_LOG_BYTES_REQUEST: {
                GetLogBytesRequestCommand getLogRequest = (GetLogBytesRequestCommand)JSONUtils.parseObject((byte[])command.getBody(), GetLogBytesRequestCommand.class);
                byte[] bytes = this.getFileContentBytes(getLogRequest.getPath());
                GetLogBytesResponseCommand getLogResponse = new GetLogBytesResponseCommand(bytes);
                channel.writeAndFlush((Object)getLogResponse.convert2Command(command.getOpaque()));
                break;
            }
            case VIEW_WHOLE_LOG_REQUEST: {
                ViewLogRequestCommand viewLogRequest = (ViewLogRequestCommand)JSONUtils.parseObject((byte[])command.getBody(), ViewLogRequestCommand.class);
                String msg = LoggerUtils.readWholeFileContent((String)viewLogRequest.getPath());
                ViewLogResponseCommand viewLogResponse = new ViewLogResponseCommand(msg);
                channel.writeAndFlush((Object)viewLogResponse.convert2Command(command.getOpaque()));
                break;
            }
            case ROLL_VIEW_LOG_REQUEST: {
                RollViewLogRequestCommand rollViewLogRequest = (RollViewLogRequestCommand)JSONUtils.parseObject((byte[])command.getBody(), RollViewLogRequestCommand.class);
                List<String> lines = this.readPartFileContent(rollViewLogRequest.getPath(), rollViewLogRequest.getSkipLineNum(), rollViewLogRequest.getLimit());
                StringBuilder builder = new StringBuilder();
                for (String line : lines) {
                    builder.append(line + "\r\n");
                }
                RollViewLogResponseCommand rollViewLogRequestResponse = new RollViewLogResponseCommand(builder.toString());
                channel.writeAndFlush((Object)rollViewLogRequestResponse.convert2Command(command.getOpaque()));
                break;
            }
            case REMOVE_TAK_LOG_REQUEST: {
                RemoveTaskLogRequestCommand removeTaskLogRequest = (RemoveTaskLogRequestCommand)JSONUtils.parseObject((byte[])command.getBody(), RemoveTaskLogRequestCommand.class);
                String taskLogPath = removeTaskLogRequest.getPath();
                File taskLogFile = new File(taskLogPath);
                Boolean status = true;
                try {
                    if (taskLogFile.exists()) {
                        status = taskLogFile.delete();
                    }
                }
                catch (Exception e) {
                    status = false;
                }
                RemoveTaskLogResponseCommand removeTaskLogResponse = new RemoveTaskLogResponseCommand(status);
                channel.writeAndFlush((Object)removeTaskLogResponse.convert2Command(command.getOpaque()));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown commandType");
            }
        }
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    /*
     * Exception decompiling
     */
    private byte[] getFileContentBytes(String filePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> readPartFileContent(String filePath, int skipLine, int limit) {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            try (Stream<String> stream = Files.lines(Paths.get(filePath, new String[0]));){
                List<String> list = stream.skip(skipLine).limit(limit).collect(Collectors.toList());
                return list;
            }
            catch (IOException e) {
                this.logger.error("read file error", (Throwable)e);
                return Collections.emptyList();
            }
        }
        this.logger.info("file path: {} not exists", (Object)filePath);
        return Collections.emptyList();
    }
}

