/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.rpc.serializer;

import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.rpc.serializer.Serializer;

public class ProtoStuffSerializer
implements Serializer {
    private static LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
    private static Map<Class<?>, Schema<?>> schemaCache = new ConcurrentHashMap();

    private static <T> Schema<T> getSchema(Class<T> clazz) {
        return schemaCache.computeIfAbsent(clazz, RuntimeSchema::createFrom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> byte[] serialize(T obj) {
        byte[] data;
        Class<?> clazz = obj.getClass();
        Schema<?> schema = ProtoStuffSerializer.getSchema(clazz);
        try {
            data = ProtostuffIOUtil.toByteArray(obj, schema, (LinkedBuffer)buffer);
        }
        finally {
            buffer.clear();
        }
        return data;
    }

    @Override
    public <T> T deserialize(byte[] data, Class<T> clz) {
        Schema<T> schema = ProtoStuffSerializer.getSchema(clz);
        Object obj = schema.newMessage();
        if (null == obj) {
            return null;
        }
        ProtostuffIOUtil.mergeFrom((byte[])data, (Object)obj, schema);
        return (T)obj;
    }
}

