/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.processor;

import io.netty.channel.Channel;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.LogUtils;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.command.MessageType;
import org.apache.dolphinscheduler.remote.command.log.ViewLogRequest;
import org.apache.dolphinscheduler.remote.command.log.ViewLogResponseResponse;
import org.apache.dolphinscheduler.remote.processor.BaseLogProcessor;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ViewWholeLogProcessor
extends BaseLogProcessor
implements NettyRequestProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ViewWholeLogProcessor.class);

    @Override
    public void process(Channel channel, Message message) {
        ViewLogRequest viewLogRequest = (ViewLogRequest)JSONUtils.parseObject((byte[])message.getBody(), ViewLogRequest.class);
        String viewLogPath = viewLogRequest.getPath();
        String msg = LogUtils.readWholeFileContent((String)viewLogPath);
        ViewLogResponseResponse viewLogResponse = new ViewLogResponseResponse(msg);
        channel.writeAndFlush((Object)viewLogResponse.convert2Command(message.getOpaque()));
    }

    @Override
    public MessageType getCommandType() {
        return MessageType.VIEW_WHOLE_LOG_REQUEST;
    }
}

