/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.processor;

import io.netty.channel.Channel;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.dolphinscheduler.remote.NettyRemotingClient;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.config.NettyClientConfig;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.apache.dolphinscheduler.remote.processor.NettyRemoteChannel;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StateEventCallbackService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StateEventCallbackService.class);
    private static final int[] RETRY_BACKOFF = new int[]{1, 2, 3, 5, 10, 20, 40, 100, 100, 100, 100, 200, 200, 200};
    private static final ConcurrentHashMap<String, NettyRemoteChannel> REMOTE_CHANNELS = new ConcurrentHashMap();
    private final NettyRemotingClient nettyRemotingClient;

    public StateEventCallbackService() {
        NettyClientConfig clientConfig = new NettyClientConfig();
        this.nettyRemotingClient = new NettyRemotingClient(clientConfig);
    }

    public void addRemoteChannel(String host, NettyRemoteChannel channel) {
        REMOTE_CHANNELS.put(host, channel);
    }

    private Optional<NettyRemoteChannel> newRemoteChannel(Host host) {
        NettyRemoteChannel nettyRemoteChannel = REMOTE_CHANNELS.get(host.getAddress());
        if (nettyRemoteChannel != null && nettyRemoteChannel.isActive()) {
            return Optional.of(nettyRemoteChannel);
        }
        Channel newChannel = this.nettyRemotingClient.getChannel(host);
        if (newChannel != null) {
            return Optional.of(this.newRemoteChannel(newChannel, host.getAddress()));
        }
        return Optional.empty();
    }

    public long pause(int ntries) {
        return 1000L * (long)RETRY_BACKOFF[ntries % RETRY_BACKOFF.length];
    }

    private NettyRemoteChannel newRemoteChannel(Channel newChannel, long opaque, String host) {
        NettyRemoteChannel remoteChannel = new NettyRemoteChannel(newChannel, opaque);
        this.addRemoteChannel(host, remoteChannel);
        return remoteChannel;
    }

    private NettyRemoteChannel newRemoteChannel(Channel newChannel, String host) {
        NettyRemoteChannel remoteChannel = new NettyRemoteChannel(newChannel);
        this.addRemoteChannel(host, remoteChannel);
        return remoteChannel;
    }

    public void remove(String host) {
        REMOTE_CHANNELS.remove(host);
    }

    public void sendResult(Host host, Message message) {
        log.info("send result, host:{}, command:{}", (Object)host.getAddress(), (Object)message.toString());
        this.newRemoteChannel(host).ifPresent(nettyRemoteChannel -> nettyRemoteChannel.writeAndFlush(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message sendSync(Host host, Message requestMessage) {
        try {
            Message message = this.nettyRemotingClient.sendSync(host, requestMessage, 60000L);
            return message;
        }
        catch (InterruptedException e) {
            log.error("send sync fail, host:{}, command:{}", new Object[]{host, requestMessage, e});
            Thread.currentThread().interrupt();
        }
        catch (RemotingException e) {
            log.error("send sync fail, host:{}, command:{}", new Object[]{host, requestMessage, e});
        }
        finally {
            this.nettyRemotingClient.closeChannel(host);
        }
        return null;
    }
}

