/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.processor;

import io.netty.channel.Channel;
import java.io.File;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.command.MessageType;
import org.apache.dolphinscheduler.remote.command.log.RemoveTaskLogRequest;
import org.apache.dolphinscheduler.remote.command.log.RemoveTaskLogResponse;
import org.apache.dolphinscheduler.remote.processor.BaseLogProcessor;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RemoveTaskLogProcessor
extends BaseLogProcessor
implements NettyRequestProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemoveTaskLogProcessor.class);

    @Override
    public void process(Channel channel, Message message) {
        RemoveTaskLogRequest removeTaskLogRequest = (RemoveTaskLogRequest)JSONUtils.parseObject((byte[])message.getBody(), RemoveTaskLogRequest.class);
        String taskLogPath = removeTaskLogRequest.getPath();
        File taskLogFile = new File(taskLogPath);
        boolean status = true;
        try {
            if (taskLogFile.exists()) {
                status = taskLogFile.delete();
            }
        }
        catch (Exception e) {
            status = false;
        }
        RemoveTaskLogResponse removeTaskLogResponse = new RemoveTaskLogResponse(status);
        channel.writeAndFlush((Object)removeTaskLogResponse.convert2Command(message.getOpaque()));
    }

    @Override
    public MessageType getCommandType() {
        return MessageType.REMOVE_TAK_LOG_REQUEST;
    }
}

