/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.processor;

import io.netty.channel.Channel;
import java.util.List;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContextCacheManager;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.command.MessageType;
import org.apache.dolphinscheduler.remote.command.log.GetAppIdRequest;
import org.apache.dolphinscheduler.remote.command.log.GetAppIdResponse;
import org.apache.dolphinscheduler.remote.processor.BaseLogProcessor;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GetAppIdProcessor
extends BaseLogProcessor
implements NettyRequestProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetAppIdProcessor.class);

    @Override
    public void process(Channel channel, Message message) {
        GetAppIdRequest getAppIdRequest = (GetAppIdRequest)JSONUtils.parseObject((byte[])message.getBody(), GetAppIdRequest.class);
        TaskExecutionContext taskExecutionContext = TaskExecutionContextCacheManager.getByTaskInstanceId((Integer)getAppIdRequest.getTaskInstanceId());
        String appInfoPath = taskExecutionContext.getAppInfoPath();
        String logPath = getAppIdRequest.getLogPath();
        List appIds = LogUtils.getAppIds((String)logPath, (String)appInfoPath, (String)PropertyUtils.getString((String)"appId.collect", (String)"log"));
        channel.writeAndFlush((Object)new GetAppIdResponse(appIds).convert2Command(message.getOpaque()));
    }

    @Override
    public MessageType getCommandType() {
        return MessageType.GET_APP_ID_REQUEST;
    }
}

