/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.command;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dolphinscheduler.remote.command.MessageContext;
import org.apache.dolphinscheduler.remote.command.MessageType;

public class Message
implements Serializable {
    private static final long serialVersionUID = -1L;
    private static final AtomicLong REQUEST_ID = new AtomicLong(1L);
    public static final byte MAGIC = -66;
    public static final byte VERSION = 0;
    private MessageType type;
    private long opaque;
    private MessageContext context = new MessageContext();
    private byte[] body;

    public Message() {
        this.opaque = REQUEST_ID.getAndIncrement();
    }

    public Message(long opaque) {
        this.opaque = opaque;
    }

    public MessageType getType() {
        return this.type;
    }

    public void setType(MessageType type) {
        this.type = type;
    }

    public long getOpaque() {
        return this.opaque;
    }

    public void setOpaque(long opaque) {
        this.opaque = opaque;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public MessageContext getContext() {
        return this.context;
    }

    public void setContext(MessageContext context) {
        this.context = context;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.opaque ^ this.opaque >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Message other = (Message)obj;
        return this.opaque == other.opaque;
    }

    public String toString() {
        return "Command [type=" + (Object)((Object)this.type) + ", opaque=" + this.opaque + ", bodyLen=" + (this.body == null ? 0 : this.body.length) + "]";
    }
}

