/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.microbench.base;

import java.io.File;
import java.io.IOException;
import lombok.Generated;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Warmup(iterations=10)
@Measurement(iterations=10)
@State(value=Scope.Thread)
@Fork(value=2)
public abstract class AbstractBaseBenchmark {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractBaseBenchmark.class);
    static final int DEFAULT_WARMUP_ITERATIONS = 10;
    static final int DEFAULT_MEASURE_ITERATIONS = 10;
    static final int DEFAULT_FORKS = 2;

    private ChainedOptionsBuilder newOptionsBuilder() {
        String output;
        String className = this.getClass().getSimpleName();
        ChainedOptionsBuilder optBuilder = new OptionsBuilder().include(className);
        if (this.getMeasureIterations() > 0) {
            optBuilder.warmupIterations(this.getMeasureIterations());
        }
        if (this.getMeasureIterations() > 0) {
            optBuilder.measurementIterations(this.getMeasureIterations());
        }
        if (AbstractBaseBenchmark.getForks() > 0) {
            optBuilder.forks(AbstractBaseBenchmark.getForks());
        }
        if ((output = AbstractBaseBenchmark.getReportDir()) != null) {
            boolean writeFileStatus;
            String filePath = AbstractBaseBenchmark.getReportDir() + className + ".json";
            File file = new File(filePath);
            if (file.exists()) {
                writeFileStatus = file.delete();
            } else {
                writeFileStatus = file.getParentFile().mkdirs();
                try {
                    writeFileStatus = file.createNewFile();
                }
                catch (IOException e) {
                    log.warn("jmh test create file error" + e);
                }
            }
            if (writeFileStatus) {
                optBuilder.resultFormat(ResultFormatType.JSON).result(filePath);
            }
        }
        return optBuilder;
    }

    @Test
    public void run() throws Exception {
        new Runner(this.newOptionsBuilder().build()).run();
    }

    private int getWarmupIterations() {
        String value = System.getProperty("warmupIterations");
        return null != value ? Integer.parseInt(value) : -1;
    }

    private int getMeasureIterations() {
        String value = System.getProperty("measureIterations");
        return null != value ? Integer.parseInt(value) : -1;
    }

    private static String getReportDir() {
        return System.getProperty("perfReportDir");
    }

    private static int getForks() {
        String forkCount = System.getProperty("forkCount");
        if (forkCount == null) {
            return -1;
        }
        try {
            return Integer.parseInt(forkCount);
        }
        catch (NumberFormatException e) {
            log.error("fail to convert forkCount into int", (Throwable)e);
            return -1;
        }
    }
}

