/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.utils.TaskTypeUtils;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowExecutionGraph;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;

public class WorkflowExecutionGraph
implements IWorkflowExecutionGraph {
    private final Map<String, ITaskExecutionRunnable> totalTaskExecuteRunnableMap;
    private final Set<String> failureTaskChains = new HashSet<String>();
    private final Set<String> pausedTaskChains = new HashSet<String>();
    private final Set<String> killedTaskChains = new HashSet<String>();
    private final Set<String> skippedTask = new HashSet<String>();
    private final Map<String, Set<String>> predecessors = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> successors = new HashMap<String, Set<String>>();
    private final Set<String> activeTaskExecutionRunnable;
    private final Set<String> inActiveTaskExecutionRunnable;

    public WorkflowExecutionGraph() {
        this.totalTaskExecuteRunnableMap = new HashMap<String, ITaskExecutionRunnable>();
        this.activeTaskExecutionRunnable = new HashSet<String>();
        this.inActiveTaskExecutionRunnable = new HashSet<String>();
    }

    @Override
    public void addNode(ITaskExecutionRunnable taskExecutionRunnable) {
        this.totalTaskExecuteRunnableMap.put(taskExecutionRunnable.getName(), taskExecutionRunnable);
        this.predecessors.computeIfAbsent(taskExecutionRunnable.getName(), k -> new HashSet());
        this.successors.computeIfAbsent(taskExecutionRunnable.getName(), k -> new HashSet());
    }

    @Override
    public void addEdge(String fromTaskName, Set<String> toTaskNames) {
        this.successors.computeIfAbsent(fromTaskName, k -> new HashSet()).addAll(toTaskNames);
        toTaskNames.forEach(toTask -> this.predecessors.computeIfAbsent((String)toTask, k -> new HashSet()).add(fromTaskName));
    }

    @Override
    public void removeUnReachableEdge() {
        Consumer<Map> removeUnReachableEdge = edgeMap -> {
            Iterator iterator = edgeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!this.totalTaskExecuteRunnableMap.containsKey(entry.getKey())) {
                    iterator.remove();
                    continue;
                }
                Set toTasks = (Set)entry.getValue();
                toTasks.removeIf(toTask -> !this.totalTaskExecuteRunnableMap.containsKey(toTask));
            }
        };
        removeUnReachableEdge.accept(this.successors);
        removeUnReachableEdge.accept(this.predecessors);
    }

    @Override
    public List<ITaskExecutionRunnable> getStartNodes() {
        return this.totalTaskExecuteRunnableMap.values().stream().filter(taskExecutionRunnable -> CollectionUtils.isEmpty((Collection)this.predecessors.get(taskExecutionRunnable.getName()))).collect(Collectors.toList());
    }

    @Override
    public List<ITaskExecutionRunnable> getPredecessors(String taskName) {
        if (!this.predecessors.containsKey(taskName)) {
            throw new IllegalArgumentException("Cannot find the task: " + taskName + " in graph");
        }
        return this.predecessors.get(taskName).stream().map(this::getTaskExecutionRunnableByName).collect(Collectors.toList());
    }

    @Override
    public List<ITaskExecutionRunnable> getSuccessors(String taskName) {
        if (!this.successors.containsKey(taskName)) {
            throw new IllegalArgumentException("Cannot find the task code in graph");
        }
        return this.successors.get(taskName).stream().map(this::getTaskExecutionRunnableByName).collect(Collectors.toList());
    }

    @Override
    public List<ITaskExecutionRunnable> getSuccessors(ITaskExecutionRunnable taskExecutionRunnable) {
        return this.getSuccessors(taskExecutionRunnable.getName());
    }

    @Override
    public ITaskExecutionRunnable getTaskExecutionRunnableByName(String taskName) {
        return this.totalTaskExecuteRunnableMap.get(taskName);
    }

    @Override
    public ITaskExecutionRunnable getTaskExecutionRunnableById(Integer taskInstanceId) {
        return this.totalTaskExecuteRunnableMap.values().stream().filter(taskExecutionRunnable -> taskExecutionRunnable.getTaskInstance() != null && taskInstanceId.equals(taskExecutionRunnable.getTaskInstance().getId())).findFirst().orElse(null);
    }

    @Override
    public ITaskExecutionRunnable getTaskExecutionRunnableByTaskCode(Long taskCode) {
        return this.totalTaskExecuteRunnableMap.values().stream().filter(taskExecutionRunnable -> taskExecutionRunnable.getTaskDefinition() != null && taskCode.equals(taskExecutionRunnable.getTaskDefinition().getCode())).findFirst().orElse(null);
    }

    @Override
    public boolean isTaskExecutionRunnableActive(ITaskExecutionRunnable taskExecutionRunnable) {
        return this.activeTaskExecutionRunnable.contains(taskExecutionRunnable.getName());
    }

    @Override
    public boolean isTaskExecutionRunnableInActive(ITaskExecutionRunnable taskExecutionRunnable) {
        return this.inActiveTaskExecutionRunnable.contains(taskExecutionRunnable.getName());
    }

    @Override
    public boolean isTaskExecutionRunnableKilled(ITaskExecutionRunnable taskExecutionRunnable) {
        return this.killedTaskChains.contains(taskExecutionRunnable.getName());
    }

    @Override
    public boolean isTaskExecutionRunnableFailed(ITaskExecutionRunnable taskExecutionRunnable) {
        return this.failureTaskChains.contains(taskExecutionRunnable.getName());
    }

    @Override
    public boolean isTaskExecutionRunnablePaused(ITaskExecutionRunnable taskExecutionRunnable) {
        return this.pausedTaskChains.contains(taskExecutionRunnable.getName());
    }

    @Override
    public List<ITaskExecutionRunnable> getActiveTaskExecutionRunnable() {
        return this.activeTaskExecutionRunnable.stream().map(this::getTaskExecutionRunnableByName).collect(Collectors.toList());
    }

    @Override
    public List<ITaskExecutionRunnable> getAllTaskExecutionRunnable() {
        return new ArrayList<ITaskExecutionRunnable>(this.totalTaskExecuteRunnableMap.values());
    }

    @Override
    public boolean isTriggerConditionMet(ITaskExecutionRunnable taskExecutionRunnable) {
        if (this.isTaskExecutionRunnableActive(taskExecutionRunnable) || this.isTaskExecutionRunnableInActive(taskExecutionRunnable)) {
            return false;
        }
        return this.getPredecessors(taskExecutionRunnable.getName()).stream().allMatch(predecessor -> this.isTaskExecutionRunnableInActive((ITaskExecutionRunnable)predecessor) && !this.isTaskExecutionRunnableFailed((ITaskExecutionRunnable)predecessor) && !this.isTaskExecutionRunnablePaused((ITaskExecutionRunnable)predecessor) && !this.isTaskExecutionRunnableKilled((ITaskExecutionRunnable)predecessor));
    }

    @Override
    public boolean isAllTaskExecutionRunnableChainFinish() {
        return this.activeTaskExecutionRunnable.isEmpty();
    }

    @Override
    public boolean isAllTaskExecutionRunnableChainSuccess() {
        if (!this.isAllTaskExecutionRunnableChainFinish()) {
            return false;
        }
        return !this.isExistFailureTaskExecutionRunnableChain() && !this.isExistPausedTaskExecutionRunnableChain() && !this.isExistKilledTaskExecutionRunnableChain();
    }

    @Override
    public boolean isExistFailureTaskExecutionRunnableChain() {
        return CollectionUtils.isNotEmpty(this.failureTaskChains);
    }

    @Override
    public boolean isExistPausedTaskExecutionRunnableChain() {
        return CollectionUtils.isNotEmpty(this.pausedTaskChains);
    }

    @Override
    public boolean isExistKilledTaskExecutionRunnableChain() {
        return CollectionUtils.isNotEmpty(this.killedTaskChains);
    }

    @Override
    public void markTaskExecutionRunnableActive(ITaskExecutionRunnable taskExecutionRunnable) {
        this.activeTaskExecutionRunnable.add(taskExecutionRunnable.getName());
    }

    @Override
    public void markTaskExecutionRunnableInActive(ITaskExecutionRunnable taskExecutionRunnable) {
        this.activeTaskExecutionRunnable.remove(taskExecutionRunnable.getName());
        this.inActiveTaskExecutionRunnable.add(taskExecutionRunnable.getName());
    }

    @Override
    public void markTaskExecutionRunnableChainFailure(ITaskExecutionRunnable taskExecutionRunnable) {
        this.assertTaskExecutionRunnableState(taskExecutionRunnable, TaskExecutionStatus.FAILURE);
        this.failureTaskChains.add(taskExecutionRunnable.getName());
    }

    @Override
    public void markTaskExecutionRunnableChainPause(ITaskExecutionRunnable taskExecutionRunnable) {
        this.assertTaskExecutionRunnableState(taskExecutionRunnable, TaskExecutionStatus.PAUSE);
        this.pausedTaskChains.add(taskExecutionRunnable.getName());
    }

    @Override
    public void markTaskExecutionRunnableChainKill(ITaskExecutionRunnable taskExecutionRunnable) {
        this.assertTaskExecutionRunnableState(taskExecutionRunnable, TaskExecutionStatus.KILL);
        this.killedTaskChains.add(taskExecutionRunnable.getName());
    }

    @Override
    public void markTaskSkipped(ITaskExecutionRunnable taskExecutionRunnable) {
        this.markTaskSkipped(taskExecutionRunnable.getName());
    }

    @Override
    public void markTaskSkipped(String taskName) {
        this.skippedTask.add(taskName);
    }

    @Override
    public boolean isEndOfTaskChain(ITaskExecutionRunnable taskExecutionRunnable) {
        return this.successors.get(taskExecutionRunnable.getName()).isEmpty() || this.isTaskExecutionRunnableKilled(taskExecutionRunnable) || this.isTaskExecutionRunnablePaused(taskExecutionRunnable) || this.isTaskExecutionRunnableFailed(taskExecutionRunnable);
    }

    @Override
    public boolean isTaskExecutionRunnableSkipped(ITaskExecutionRunnable taskExecutionRunnable) {
        return this.skippedTask.contains(taskExecutionRunnable.getName());
    }

    @Override
    public boolean isTaskExecutionRunnableForbidden(ITaskExecutionRunnable taskExecutionRunnable) {
        return taskExecutionRunnable.getTaskDefinition().getFlag() == Flag.NO;
    }

    @Override
    public boolean isTaskExecutionRunnableRetrying(ITaskExecutionRunnable taskExecutionRunnable) {
        if (!taskExecutionRunnable.isTaskInstanceInitialized()) {
            return false;
        }
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        return taskInstance.getState() == TaskExecutionStatus.FAILURE && taskExecutionRunnable.isTaskInstanceCanRetry() && this.isTaskExecutionRunnableActive(taskExecutionRunnable);
    }

    @Override
    public boolean isAllPredecessorsSkipped(ITaskExecutionRunnable taskExecutionRunnable) {
        List<ITaskExecutionRunnable> predecessors = this.getPredecessors(taskExecutionRunnable.getName());
        if (CollectionUtils.isEmpty(predecessors)) {
            return false;
        }
        return CollectionUtils.isEmpty(predecessors) || predecessors.stream().allMatch(this::isTaskExecutionRunnableSkipped);
    }

    @Override
    public boolean isAllSuccessorsAreConditionTask(ITaskExecutionRunnable taskExecutionRunnable) {
        List<ITaskExecutionRunnable> successors = this.getSuccessors(taskExecutionRunnable.getName());
        if (CollectionUtils.isEmpty(successors)) {
            return false;
        }
        return successors.stream().allMatch(successor -> this.isTaskExecutionRunnableSkipped((ITaskExecutionRunnable)successor) || TaskTypeUtils.isConditionTask((String)taskExecutionRunnable.getTaskInstance().getTaskType()));
    }

    private void assertTaskExecutionRunnableState(ITaskExecutionRunnable taskExecutionRunnable, TaskExecutionStatus taskExecutionStatus) {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        if (taskInstance.getState() == taskExecutionStatus) {
            return;
        }
        throw new IllegalStateException("The task: " + taskExecutionRunnable.getName() + " state: " + taskInstance.getState() + " is not " + taskExecutionStatus);
    }
}

