/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.executor.plugin.dependent;

import lombok.Generated;
import org.apache.dolphinscheduler.dao.repository.ProjectDao;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceContextDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowDefinitionDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.master.engine.IWorkflowRepository;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.ILogicTaskPluginFactory;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.dependent.DependentLogicTask;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.exception.LogicTaskInitializeException;
import org.apache.dolphinscheduler.task.executor.ITaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DependentLogicTaskPluginFactory
implements ILogicTaskPluginFactory<DependentLogicTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DependentLogicTaskPluginFactory.class);
    @Autowired
    private ProjectDao projectDao;
    @Autowired
    private WorkflowDefinitionDao workflowDefinitionDao;
    @Autowired
    private TaskDefinitionDao taskDefinitionDao;
    @Autowired
    private TaskInstanceDao taskInstanceDao;
    @Autowired
    private TaskInstanceContextDao taskInstanceContextDao;
    @Autowired
    private WorkflowInstanceDao workflowInstanceDao;
    @Autowired
    private IWorkflowRepository IWorkflowRepository;

    @Override
    public DependentLogicTask createLogicTask(ITaskExecutor taskExecutor) throws LogicTaskInitializeException {
        TaskExecutionContext taskExecutionContext = taskExecutor.getTaskExecutionContext();
        int workflowInstanceId = taskExecutionContext.getWorkflowInstanceId();
        IWorkflowExecutionRunnable workflowExecutionRunnable = this.IWorkflowRepository.get(workflowInstanceId);
        if (workflowExecutionRunnable == null) {
            throw new LogicTaskInitializeException("Cannot find the WorkflowExecuteRunnable: " + workflowInstanceId);
        }
        return new DependentLogicTask(taskExecutionContext, this.projectDao, this.workflowDefinitionDao, this.taskDefinitionDao, this.taskInstanceDao, this.workflowInstanceDao, workflowExecutionRunnable, this.taskInstanceContextDao);
    }

    @Override
    public String getTaskType() {
        return "DEPENDENT";
    }
}

