/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.common.service.impl;

import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.common.utils.LogUtils;
import org.apache.dolphinscheduler.extract.common.ILogService;
import org.apache.dolphinscheduler.extract.common.transportor.LogResponseStatus;
import org.apache.dolphinscheduler.extract.common.transportor.TaskInstanceLogFileDownloadRequest;
import org.apache.dolphinscheduler.extract.common.transportor.TaskInstanceLogFileDownloadResponse;
import org.apache.dolphinscheduler.extract.common.transportor.TaskInstanceLogPageQueryRequest;
import org.apache.dolphinscheduler.extract.common.transportor.TaskInstanceLogPageQueryResponse;

public class LogServiceImpl
implements ILogService {
    @Override
    public TaskInstanceLogFileDownloadResponse getTaskInstanceWholeLogFileBytes(TaskInstanceLogFileDownloadRequest taskInstanceLogFileDownloadRequest) {
        TaskInstanceLogFileDownloadResponse taskInstanceLogFileDownloadResponse = new TaskInstanceLogFileDownloadResponse();
        try {
            byte[] bytes = LogUtils.getFileContentBytesFromLocal((String)taskInstanceLogFileDownloadRequest.getTaskInstanceLogAbsolutePath());
            taskInstanceLogFileDownloadResponse.setLogBytes(bytes);
        }
        catch (Exception e) {
            taskInstanceLogFileDownloadResponse.setCode(LogResponseStatus.ERROR);
            taskInstanceLogFileDownloadResponse.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return taskInstanceLogFileDownloadResponse;
    }

    @Override
    public TaskInstanceLogPageQueryResponse pageQueryTaskInstanceLog(TaskInstanceLogPageQueryRequest taskInstanceLogPageQueryRequest) {
        TaskInstanceLogPageQueryResponse taskInstanceLogPageQueryResponse = new TaskInstanceLogPageQueryResponse();
        try {
            List lines = LogUtils.readPartFileContentFromLocal((String)taskInstanceLogPageQueryRequest.getTaskInstanceLogAbsolutePath(), (int)taskInstanceLogPageQueryRequest.getSkipLineNum(), (int)taskInstanceLogPageQueryRequest.getLimit());
            taskInstanceLogPageQueryResponse.setLogContent(LogUtils.rollViewLogLines((List)lines));
        }
        catch (Exception e) {
            taskInstanceLogPageQueryResponse.setCode(LogResponseStatus.ERROR);
            taskInstanceLogPageQueryResponse.setMessage(ExceptionUtils.getMessage((Throwable)e));
        }
        return taskInstanceLogPageQueryResponse;
    }

    @Override
    public void removeTaskInstanceLog(String taskInstanceLogAbsolutePath) {
        FileUtils.deleteFile((String)taskInstanceLogAbsolutePath);
    }
}

