/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.base.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.dolphinscheduler.extract.base.client.ClientInvocationHandler;
import org.apache.dolphinscheduler.extract.base.client.IRpcClientProxyFactory;
import org.apache.dolphinscheduler.extract.base.client.NettyRemotingClient;
import org.apache.dolphinscheduler.extract.base.utils.Host;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JdkDynamicRpcClientProxyFactory
implements IRpcClientProxyFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdkDynamicRpcClientProxyFactory.class);
    private final NettyRemotingClient nettyRemotingClient;
    private static final LoadingCache<String, Map<String, Object>> proxyClientCache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofHours(1L)).removalListener(notification -> {
        log.warn("Remove DynamicRpcClientProxy cache for host: {}", notification.getKey());
        ((Map)notification.getValue()).clear();
    }).build((CacheLoader)new CacheLoader<String, Map<String, Object>>(){

        public Map<String, Object> load(String host) {
            log.info("Create DynamicRpcClientProxy cache for host: {}", (Object)host);
            return new ConcurrentHashMap<String, Object>();
        }
    });

    JdkDynamicRpcClientProxyFactory(NettyRemotingClient nettyRemotingClient) {
        this.nettyRemotingClient = nettyRemotingClient;
    }

    @Override
    public <T> T getProxyClient(String serverHost, Class<T> clientInterface) {
        return (T)((Map)proxyClientCache.get((Object)serverHost)).computeIfAbsent(clientInterface.getName(), key -> this.newProxyClient(serverHost, clientInterface));
    }

    private <T> T newProxyClient(String serverHost, Class<T> clientInterface) {
        return (T)Proxy.newProxyInstance(clientInterface.getClassLoader(), new Class[]{clientInterface}, (InvocationHandler)new ClientInvocationHandler(Host.of(serverHost), this.nettyRemotingClient));
    }
}

