/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.starrocks.param;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.starrocks.param.StarRocksConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.starrocks.param.StarRocksDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={DataSourceProcessor.class})
public class StarRocksDataSourceProcessor
extends AbstractDataSourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StarRocksDataSourceProcessor.class);
    private static final String ALLOW_LOAD_LOCAL_IN_FILE_NAME = "allowLoadLocalInfile";
    private static final String AUTO_DESERIALIZE = "autoDeserialize";
    private static final String ALLOW_LOCAL_IN_FILE_NAME = "allowLocalInfile";
    private static final String ALLOW_URL_IN_LOCAL_IN_FILE_NAME = "allowUrlInLocalInfile";
    private static final String APPEND_PARAMS = "allowLoadLocalInfile=false&autoDeserialize=false&allowLocalInfile=false&allowUrlInLocalInfile=false";

    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, StarRocksDataSourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        StarRocksConnectionParam connectionParams = (StarRocksConnectionParam)this.createConnectionParams(connectionJson);
        StarRocksDataSourceParamDTO starRocksDataSourceParamDTO = new StarRocksDataSourceParamDTO();
        starRocksDataSourceParamDTO.setUserName(connectionParams.getUser());
        starRocksDataSourceParamDTO.setDatabase(connectionParams.getDatabase());
        starRocksDataSourceParamDTO.setOther(connectionParams.getOther());
        String address = connectionParams.getAddress();
        String[] hostSeperator = address.split("//");
        String[] hostPortArray = hostSeperator[hostSeperator.length - 1].split(",");
        starRocksDataSourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        starRocksDataSourceParamDTO.setHost(hostPortArray[0].split(":")[0]);
        return starRocksDataSourceParamDTO;
    }

    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO dataSourceParam) {
        StarRocksDataSourceParamDTO starRocksDataSourceParamDTO = (StarRocksDataSourceParamDTO)dataSourceParam;
        String address = String.format("%s%s:%s", "jdbc:mysql://", starRocksDataSourceParamDTO.getHost(), starRocksDataSourceParamDTO.getPort());
        String jdbcUrl = String.format("%s/%s", address, starRocksDataSourceParamDTO.getDatabase());
        StarRocksConnectionParam starRocksConnectionParam = new StarRocksConnectionParam();
        starRocksConnectionParam.setJdbcUrl(jdbcUrl);
        starRocksConnectionParam.setDatabase(starRocksDataSourceParamDTO.getDatabase());
        starRocksConnectionParam.setAddress(address);
        starRocksConnectionParam.setUser(starRocksDataSourceParamDTO.getUserName());
        starRocksConnectionParam.setPassword(PasswordUtils.encodePassword((String)starRocksDataSourceParamDTO.getPassword()));
        starRocksConnectionParam.setDriverClassName(this.getDatasourceDriver());
        starRocksConnectionParam.setValidationQuery(this.getValidationQuery());
        starRocksConnectionParam.setOther(starRocksDataSourceParamDTO.getOther());
        return starRocksConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, StarRocksConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "com.mysql.cj.jdbc.Driver";
    }

    public String getValidationQuery() {
        return "select 1";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        StarRocksConnectionParam starRocksConnectionParam = (StarRocksConnectionParam)connectionParam;
        String jdbcUrl = starRocksConnectionParam.getJdbcUrl();
        if (MapUtils.isNotEmpty((Map)starRocksConnectionParam.getOther())) {
            return String.format("%s?%s&%s", jdbcUrl, this.transformOther(starRocksConnectionParam.getOther()), APPEND_PARAMS);
        }
        return String.format("%s?%s", jdbcUrl, APPEND_PARAMS);
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        String password;
        StarRocksConnectionParam starRocksConnectionParam = (StarRocksConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        String user = starRocksConnectionParam.getUser();
        if (user.contains(AUTO_DESERIALIZE)) {
            log.warn("sensitive param : {} in username field is filtered", (Object)AUTO_DESERIALIZE);
            user = user.replace(AUTO_DESERIALIZE, "");
        }
        if ((password = PasswordUtils.decodePassword((String)starRocksConnectionParam.getPassword())).contains(AUTO_DESERIALIZE)) {
            log.warn("sensitive param : {} in password field is filtered", (Object)AUTO_DESERIALIZE);
            password = password.replace(AUTO_DESERIALIZE, "");
        }
        return DriverManager.getConnection(this.getJdbcUrl(connectionParam), user, password);
    }

    public DbType getDbType() {
        return DbType.STARROCKS;
    }

    public DataSourceProcessor create() {
        return new StarRocksDataSourceProcessor();
    }

    private String transformOther(Map<String, String> paramMap) {
        if (MapUtils.isEmpty(paramMap)) {
            return null;
        }
        HashMap<String, String> otherMap = new HashMap<String, String>();
        paramMap.forEach((k, v) -> {
            if (!StarRocksDataSourceProcessor.checkKeyIsLegitimate(k)) {
                return;
            }
            otherMap.put((String)k, (String)v);
        });
        if (MapUtils.isEmpty(otherMap)) {
            return null;
        }
        ArrayList otherList = new ArrayList();
        otherMap.forEach((key, value) -> otherList.add(String.format("%s=%s", key, value)));
        return String.join((CharSequence)"&", otherList);
    }

    private static boolean checkKeyIsLegitimate(String key) {
        return !key.contains(ALLOW_LOAD_LOCAL_IN_FILE_NAME) && !key.contains(AUTO_DESERIALIZE) && !key.contains(ALLOW_LOCAL_IN_FILE_NAME) && !key.contains(ALLOW_URL_IN_LOCAL_IN_FILE_NAME);
    }
}

