/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.ssh;

import java.security.KeyPair;
import java.time.Duration;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.plugin.datasource.ssh.param.SSHConnectionParam;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.session.SessionHeartbeatController;
import org.apache.sshd.common.util.security.SecurityUtils;

public class SSHUtils {
    private SSHUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static ClientSession getSession(SshClient client, SSHConnectionParam connectionParam) throws Exception {
        String publicKey;
        ClientSession session = (ClientSession)((ConnectFuture)client.connect(connectionParam.getUser(), connectionParam.getHost(), connectionParam.getPort()).verify(5000L)).getSession();
        String password = connectionParam.getPassword();
        if (StringUtils.isNotEmpty((CharSequence)password)) {
            session.addPasswordIdentity(password);
        }
        if (StringUtils.isNotEmpty((CharSequence)(publicKey = connectionParam.getPublicKey()))) {
            try {
                KeyPairResourceParser loader = SecurityUtils.getKeyPairResourceParser();
                Collection keyPairCollection = loader.loadKeyPairs(null, null, null, publicKey);
                for (KeyPair keyPair : keyPairCollection) {
                    session.addPublicKeyIdentity(keyPair);
                }
            }
            catch (Exception e) {
                throw new Exception("Failed to add public key identity", e);
            }
        }
        session.setSessionHeartbeat(SessionHeartbeatController.HeartbeatType.IGNORE, Duration.ofSeconds(3L));
        return session;
    }
}

