/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.sagemaker;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.sagemaker.AmazonSageMaker;
import com.amazonaws.services.sagemaker.AmazonSageMakerClientBuilder;
import com.amazonaws.services.sagemaker.model.ListNotebookInstancesRequest;
import com.google.common.base.Preconditions;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagemakerClientWrapper
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SagemakerClientWrapper.class);
    private AmazonSageMaker amazonSageMaker;

    public SagemakerClientWrapper(String accessKey, String secretAccessKey, String region) {
        Preconditions.checkNotNull((Object)accessKey, (Object)"sagemaker accessKey cannot be null");
        Preconditions.checkNotNull((Object)secretAccessKey, (Object)"sagemaker secretAccessKey cannot be null");
        Preconditions.checkNotNull((Object)region, (Object)"sagemaker region cannot be null");
        BasicAWSCredentials basicAWSCredentials = new BasicAWSCredentials(accessKey, secretAccessKey);
        AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)basicAWSCredentials);
        this.amazonSageMaker = (AmazonSageMaker)((AmazonSageMakerClientBuilder)((AmazonSageMakerClientBuilder)AmazonSageMakerClientBuilder.standard().withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).withRegion(region)).build();
    }

    public boolean checkConnect() {
        try {
            ListNotebookInstancesRequest request = new ListNotebookInstancesRequest();
            this.amazonSageMaker.listNotebookInstances(request);
            log.info("sagemaker client connects to server successfully");
            return true;
        }
        catch (Exception e) {
            log.info("sagemaker client failed to connect to the server");
            return false;
        }
    }

    @Override
    public void close() {
    }
}

