/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.redshift.param;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Functions;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public enum RedshiftAuthMode {
    PASSWORD(0, "password"),
    IAM_ACCESS_KEY(1, "IAM-accessKey");

    private static final Map<Integer, RedshiftAuthMode> AUTH_TYPE_MAP;
    private final int code;
    @JsonValue
    private final String descp;

    private RedshiftAuthMode(int code, String descp) {
        this.code = code;
        this.descp = descp;
    }

    public static RedshiftAuthMode of(int type) {
        if (AUTH_TYPE_MAP.containsKey(type)) {
            return AUTH_TYPE_MAP.get(type);
        }
        return null;
    }

    public static RedshiftAuthMode ofName(String name) {
        return Arrays.stream(RedshiftAuthMode.values()).filter(e -> e.name().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException("no such auth type"));
    }

    public int getCode() {
        return this.code;
    }

    public String getDescp() {
        return this.descp;
    }

    static {
        AUTH_TYPE_MAP = Arrays.stream(RedshiftAuthMode.values()).collect(Collectors.toMap(RedshiftAuthMode::getCode, Functions.identity()));
    }
}

