/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.k8s;

import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sClientWrapper
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8sClientWrapper.class);
    private KubernetesClient client;

    public boolean checkConnect(String kubeConfigYaml, String namespace) {
        try {
            Config config = Config.fromKubeconfig((String)kubeConfigYaml);
            this.client = new KubernetesClientBuilder().withConfig(config).build();
            NamespaceList namespaceList = (NamespaceList)this.client.namespaces().list();
            if (!namespaceList.getItems().stream().anyMatch(ns -> ns.getMetadata().getName().equals(namespace))) {
                log.info("failed to connect to the K8S cluster, namespace not found\n");
                return false;
            }
            log.info("successfully connected to the K8S cluster");
            return true;
        }
        catch (Exception e) {
            log.info("failed to connect to the K8S cluster\n");
            return false;
        }
    }

    @Override
    public void close() throws Exception {
    }
}

