/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.hive.param;

import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.CommonUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.hive.param.HiveConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.hive.param.HiveDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;

@AutoService(value={DataSourceProcessor.class})
public class HiveDataSourceProcessor
extends AbstractDataSourceProcessor {
    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, HiveDataSourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        String[] hostPortArray;
        HiveDataSourceParamDTO hiveDataSourceParamDTO = new HiveDataSourceParamDTO();
        HiveConnectionParam hiveConnectionParam = (HiveConnectionParam)this.createConnectionParams(connectionJson);
        hiveDataSourceParamDTO.setDatabase(hiveConnectionParam.getDatabase());
        hiveDataSourceParamDTO.setUserName(hiveConnectionParam.getUser());
        hiveDataSourceParamDTO.setOther(hiveConnectionParam.getOther());
        hiveDataSourceParamDTO.setLoginUserKeytabUsername(hiveConnectionParam.getLoginUserKeytabUsername());
        hiveDataSourceParamDTO.setLoginUserKeytabPath(hiveConnectionParam.getLoginUserKeytabPath());
        hiveDataSourceParamDTO.setJavaSecurityKrb5Conf(hiveConnectionParam.getJavaSecurityKrb5Conf());
        hiveDataSourceParamDTO.setPrincipal(hiveConnectionParam.getPrincipal());
        String[] tmpArray = hiveConnectionParam.getAddress().split("//");
        StringBuilder hosts = new StringBuilder();
        for (String hostPort : hostPortArray = tmpArray[tmpArray.length - 1].split(",")) {
            hosts.append(hostPort.split(":")[0]).append(",");
        }
        hosts.deleteCharAt(hosts.length() - 1);
        hiveDataSourceParamDTO.setHost(hosts.toString());
        hiveDataSourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        return hiveDataSourceParamDTO;
    }

    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        HiveDataSourceParamDTO hiveParam = (HiveDataSourceParamDTO)datasourceParam;
        StringBuilder address = new StringBuilder();
        address.append("jdbc:hive2://");
        for (String zkHost : hiveParam.getHost().split(",")) {
            address.append(String.format("%s:%s,", zkHost, hiveParam.getPort()));
        }
        address.deleteCharAt(address.length() - 1);
        String jdbcUrl = address.toString() + "/" + hiveParam.getDatabase();
        HiveConnectionParam hiveConnectionParam = new HiveConnectionParam();
        hiveConnectionParam.setDatabase(hiveParam.getDatabase());
        hiveConnectionParam.setAddress(address.toString());
        hiveConnectionParam.setJdbcUrl(jdbcUrl);
        hiveConnectionParam.setUser(hiveParam.getUserName());
        hiveConnectionParam.setPassword(PasswordUtils.encodePassword((String)hiveParam.getPassword()));
        hiveConnectionParam.setDriverClassName(this.getDatasourceDriver());
        hiveConnectionParam.setValidationQuery(this.getValidationQuery());
        if (CommonUtils.getKerberosStartupState()) {
            hiveConnectionParam.setPrincipal(hiveParam.getPrincipal());
            hiveConnectionParam.setJavaSecurityKrb5Conf(hiveParam.getJavaSecurityKrb5Conf());
            hiveConnectionParam.setLoginUserKeytabPath(hiveParam.getLoginUserKeytabPath());
            hiveConnectionParam.setLoginUserKeytabUsername(hiveParam.getLoginUserKeytabUsername());
        }
        hiveConnectionParam.setOther(hiveParam.getOther());
        return hiveConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, HiveConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "org.apache.hive.jdbc.HiveDriver";
    }

    public String getValidationQuery() {
        return "select 1";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        HiveConnectionParam hiveConnectionParam = (HiveConnectionParam)connectionParam;
        StringBuilder jdbcUrlBuilder = new StringBuilder(hiveConnectionParam.getJdbcUrl());
        if (StringUtils.isNotBlank((CharSequence)hiveConnectionParam.getPrincipal())) {
            jdbcUrlBuilder.append(";principal=").append(hiveConnectionParam.getPrincipal());
        }
        if (MapUtils.isNotEmpty((Map)hiveConnectionParam.getOther())) {
            jdbcUrlBuilder.append(";").append(this.transformOther(hiveConnectionParam.getOther()));
        }
        return jdbcUrlBuilder.toString();
    }

    public Connection getConnection(ConnectionParam connectionParam) throws IOException, ClassNotFoundException, SQLException {
        HiveConnectionParam hiveConnectionParam = (HiveConnectionParam)connectionParam;
        CommonUtils.loadKerberosConf((String)hiveConnectionParam.getJavaSecurityKrb5Conf(), (String)hiveConnectionParam.getLoginUserKeytabUsername(), (String)hiveConnectionParam.getLoginUserKeytabPath());
        Class.forName(this.getDatasourceDriver());
        return DriverManager.getConnection(this.getJdbcUrl(connectionParam), hiveConnectionParam.getUser(), PasswordUtils.decodePassword((String)hiveConnectionParam.getPassword()));
    }

    public DbType getDbType() {
        return DbType.HIVE;
    }

    public DataSourceProcessor create() {
        return new HiveDataSourceProcessor();
    }

    public List<String> splitAndRemoveComment(String sql) {
        String cleanSQL = SQLParserUtils.removeComment((String)sql, (com.alibaba.druid.DbType)com.alibaba.druid.DbType.hive);
        return SQLParserUtils.split((String)cleanSQL, (com.alibaba.druid.DbType)com.alibaba.druid.DbType.hive);
    }

    private String transformOther(Map<String, String> otherMap) {
        if (MapUtils.isEmpty(otherMap)) {
            return null;
        }
        ArrayList otherList = new ArrayList();
        otherMap.forEach((key, value) -> otherList.add(String.format("%s=%s", key, value)));
        return String.join((CharSequence)";", otherList);
    }
}

