/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.dolphindb.param;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.dolphindb.param.DolphinDBConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.dolphindb.param.DolphinDBDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;

@AutoService(value={DataSourceProcessor.class})
public class DolphinDBDataSourceProcessor
extends AbstractDataSourceProcessor {
    public void checkDatasourceParam(BaseDataSourceParamDTO baseDataSourceParamDTO) {
        if (!baseDataSourceParamDTO.getType().equals((Object)DbType.REDSHIFT)) {
            this.checkHost(baseDataSourceParamDTO.getHost());
        }
        this.checkOther(baseDataSourceParamDTO.getOther());
    }

    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, DolphinDBDataSourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        DolphinDBConnectionParam connectionParams = (DolphinDBConnectionParam)this.createConnectionParams(connectionJson);
        DolphinDBDataSourceParamDTO dataSourceParamDTO = new DolphinDBDataSourceParamDTO();
        dataSourceParamDTO.setUserName(connectionParams.getUser());
        dataSourceParamDTO.setDatabase(connectionParams.getDatabase());
        dataSourceParamDTO.setOther(connectionParams.getOther());
        String[] hostSeperator = connectionParams.getAddress().split("//");
        String[] hostPortArray = hostSeperator[hostSeperator.length - 1].split(",");
        dataSourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        dataSourceParamDTO.setHost(hostPortArray[0].split(":")[0]);
        return dataSourceParamDTO;
    }

    public ConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        DolphinDBDataSourceParamDTO dolphinDBParam = (DolphinDBDataSourceParamDTO)datasourceParam;
        String address = String.format("%s%s:%s", "jdbc:dolphindb://", dolphinDBParam.getHost(), dolphinDBParam.getPort());
        String jdbcUrl = String.format("%s", address);
        DolphinDBConnectionParam dolphinDBConnectionParam = new DolphinDBConnectionParam();
        dolphinDBConnectionParam.setJdbcUrl(jdbcUrl);
        dolphinDBConnectionParam.setDatabase(dolphinDBParam.getDatabase());
        dolphinDBConnectionParam.setAddress(address);
        dolphinDBConnectionParam.setUser(dolphinDBParam.getUserName());
        dolphinDBConnectionParam.setPassword(PasswordUtils.encodePassword((String)dolphinDBParam.getPassword()));
        dolphinDBConnectionParam.setDriverClassName(this.getDatasourceDriver());
        dolphinDBConnectionParam.setValidationQuery(this.getValidationQuery());
        dolphinDBConnectionParam.setOther(dolphinDBParam.getOther());
        return dolphinDBConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, DolphinDBConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "com.dolphindb.jdbc.Driver";
    }

    public String getValidationQuery() {
        return "select 1";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        DolphinDBConnectionParam dolphinDBConnectionParam = (DolphinDBConnectionParam)connectionParam;
        if (MapUtils.isNotEmpty((Map)dolphinDBConnectionParam.getOther())) {
            return String.format("%s?%s", dolphinDBConnectionParam.getJdbcUrl(), this.transformOther(dolphinDBConnectionParam.getOther()));
        }
        return dolphinDBConnectionParam.getJdbcUrl();
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        DolphinDBConnectionParam dolphinDBConnectionParam = (DolphinDBConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        return DriverManager.getConnection(this.getJdbcUrl(connectionParam), dolphinDBConnectionParam.getUser(), PasswordUtils.decodePassword((String)dolphinDBConnectionParam.getPassword()));
    }

    public DbType getDbType() {
        return DbType.DOLPHINDB;
    }

    public DataSourceProcessor create() {
        return new DolphinDBDataSourceProcessor();
    }

    private String transformOther(Map<String, String> otherMap) {
        if (MapUtils.isEmpty(otherMap)) {
            return null;
        }
        ArrayList list = new ArrayList(otherMap.size());
        otherMap.forEach((key, value) -> list.add(String.format("%s=%s", key, value)));
        return String.join((CharSequence)"&", list);
    }
}

