/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.azuresql.param;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Functions;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public enum AzureSQLAuthMode {
    SQL_PASSWORD(0, "SqlPassword"),
    AD_PASSWORD(1, "ActiveDirectoryPassword"),
    AD_MSI(2, "ActiveDirectoryMSI"),
    AD_SERVICE_PRINCIPAL(3, "ActiveDirectoryServicePrincipal"),
    ACCESSTOKEN(4, "accessToken");

    private static final Map<Integer, AzureSQLAuthMode> AUTH_TYPE_MAP;
    private final int code;
    @JsonValue
    private final String descp;

    private AzureSQLAuthMode(int code, String descp) {
        this.code = code;
        this.descp = descp;
    }

    public static AzureSQLAuthMode of(int type) {
        if (AUTH_TYPE_MAP.containsKey(type)) {
            return AUTH_TYPE_MAP.get(type);
        }
        return null;
    }

    public static AzureSQLAuthMode ofName(String name) {
        return Arrays.stream(AzureSQLAuthMode.values()).filter(e -> e.name().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException("no such auth type"));
    }

    public int getCode() {
        return this.code;
    }

    public String getDescp() {
        return this.descp;
    }

    static {
        AUTH_TYPE_MAP = Arrays.stream(AzureSQLAuthMode.values()).collect(Collectors.toMap(AzureSQLAuthMode::getCode, Functions.identity()));
    }
}

