/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.executor.workflow;

import com.google.common.collect.Lists;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.executor.workflow.IExecutorDelegate;
import org.apache.dolphinscheduler.api.validator.workflow.BackfillWorkflowDTO;
import org.apache.dolphinscheduler.common.enums.ComplementDependentMode;
import org.apache.dolphinscheduler.common.enums.ExecutionOrder;
import org.apache.dolphinscheduler.common.enums.RunMode;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.repository.CommandDao;
import org.apache.dolphinscheduler.extract.base.client.Clients;
import org.apache.dolphinscheduler.extract.master.IWorkflowControlClient;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowBackfillTriggerRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowBackfillTriggerResponse;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BackfillWorkflowExecutorDelegate
implements IExecutorDelegate<BackfillWorkflowDTO, List<Integer>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BackfillWorkflowExecutorDelegate.class);
    @Autowired
    private CommandDao commandDao;
    @Autowired
    private ProcessService processService;
    @Autowired
    private RegistryClient registryClient;

    @Override
    public List<Integer> execute(BackfillWorkflowDTO backfillWorkflowDTO) {
        if (backfillWorkflowDTO.getBackfillParams().getRunMode() == RunMode.RUN_MODE_SERIAL) {
            return this.doSerialBackfillWorkflow(backfillWorkflowDTO);
        }
        return this.doParallelBackfillWorkflow(backfillWorkflowDTO);
    }

    private List<Integer> doSerialBackfillWorkflow(BackfillWorkflowDTO backfillWorkflowDTO) {
        BackfillWorkflowDTO.BackfillParamsDTO backfillParams = backfillWorkflowDTO.getBackfillParams();
        List<ZonedDateTime> backfillTimeList = backfillParams.getBackfillDateList();
        if (backfillParams.getExecutionOrder() == ExecutionOrder.DESC_ORDER) {
            Collections.sort(backfillTimeList, Collections.reverseOrder());
        } else {
            Collections.sort(backfillTimeList);
        }
        Integer workflowInstanceId = this.doBackfillWorkflow(backfillWorkflowDTO, backfillTimeList.stream().map(DateUtils::dateToString).collect(Collectors.toList()));
        return Lists.newArrayList((Object[])new Integer[]{workflowInstanceId});
    }

    private List<Integer> doParallelBackfillWorkflow(BackfillWorkflowDTO backfillWorkflowDTO) {
        BackfillWorkflowDTO.BackfillParamsDTO backfillParams = backfillWorkflowDTO.getBackfillParams();
        Integer expectedParallelismNumber = backfillParams.getExpectedParallelismNumber();
        List<ZonedDateTime> listDate = backfillParams.getBackfillDateList();
        expectedParallelismNumber = expectedParallelismNumber != null ? Integer.valueOf(Math.min(listDate.size(), expectedParallelismNumber)) : Integer.valueOf(listDate.size());
        log.info("In parallel mode, current expectedParallelismNumber:{}", (Object)expectedParallelismNumber);
        ArrayList workflowInstanceIdList = Lists.newArrayList();
        for (List stringDate : Lists.partition(listDate, (int)expectedParallelismNumber)) {
            Integer workflowInstanceId = this.doBackfillWorkflow(backfillWorkflowDTO, stringDate.stream().map(DateUtils::dateToString).collect(Collectors.toList()));
            workflowInstanceIdList.add(workflowInstanceId);
        }
        return workflowInstanceIdList;
    }

    private Integer doBackfillWorkflow(BackfillWorkflowDTO backfillWorkflowDTO, List<String> backfillTimeList) {
        Server masterServer = this.registryClient.getRandomServer(RegistryNodeType.MASTER).orElse(null);
        if (masterServer == null) {
            throw new ServiceException("no master server available");
        }
        WorkflowDefinition workflowDefinition = backfillWorkflowDTO.getWorkflowDefinition();
        WorkflowBackfillTriggerRequest backfillTriggerRequest = WorkflowBackfillTriggerRequest.builder().userId(backfillWorkflowDTO.getLoginUser().getId()).backfillTimeList(backfillTimeList).workflowCode(Long.valueOf(workflowDefinition.getCode())).workflowVersion(Integer.valueOf(workflowDefinition.getVersion())).startNodes(backfillWorkflowDTO.getStartNodes()).failureStrategy(backfillWorkflowDTO.getFailureStrategy()).taskDependType(backfillWorkflowDTO.getTaskDependType()).warningType(backfillWorkflowDTO.getWarningType()).warningGroupId(backfillWorkflowDTO.getWarningGroupId()).workflowInstancePriority(backfillWorkflowDTO.getWorkflowInstancePriority()).workerGroup(backfillWorkflowDTO.getWorkerGroup()).tenantCode(backfillWorkflowDTO.getTenantCode()).environmentCode(backfillWorkflowDTO.getEnvironmentCode()).startParamList(backfillWorkflowDTO.getStartParamList()).dryRun(backfillWorkflowDTO.getDryRun()).testFlag(backfillWorkflowDTO.getTestFlag()).build();
        WorkflowBackfillTriggerResponse backfillTriggerResponse = ((IWorkflowControlClient)Clients.withService(IWorkflowControlClient.class).withHost(masterServer.getHost() + ":" + masterServer.getPort())).backfillTriggerWorkflow(backfillTriggerRequest);
        if (!backfillTriggerResponse.isSuccess()) {
            throw new ServiceException("Backfill workflow failed: " + backfillTriggerResponse.getMessage());
        }
        BackfillWorkflowDTO.BackfillParamsDTO backfillParams = backfillWorkflowDTO.getBackfillParams();
        if (backfillParams.getBackfillDependentMode() == ComplementDependentMode.ALL_DEPENDENT) {
            this.doBackfillDependentWorkflow(backfillWorkflowDTO, backfillTimeList);
        }
        return backfillTriggerResponse.getWorkflowInstanceId();
    }

    private void doBackfillDependentWorkflow(BackfillWorkflowDTO backfillWorkflowDTO, List<String> backfillTimeList) {
    }
}

