/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.subtree.SubtreeSpecification;

public abstract class UserClass
implements Serializable {
    private static final long serialVersionUID = -123919984184219893L;
    public static final AllUsers ALL_USERS = new AllUsers();
    public static final ThisEntry THIS_ENTRY = new ThisEntry();
    public static final ParentOfEntry PARENT_OF_ENTRY = new ParentOfEntry();

    protected UserClass() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Subtree
    extends UserClass {
        private static final long serialVersionUID = 3949337699049701332L;
        protected final Set<SubtreeSpecification> subtreeSpecifications;

        public Subtree(Set<SubtreeSpecification> subtreeSpecs) {
            this.subtreeSpecifications = Collections.unmodifiableSet(subtreeSpecs);
        }

        public Set<SubtreeSpecification> getSubtreeSpecifications() {
            return this.subtreeSpecifications;
        }

        public int hashCode() {
            int hash = 37;
            hash = hash * 17 + ((Object)this.subtreeSpecifications).hashCode();
            return hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Subtree) {
                Subtree that = (Subtree)o;
                return ((Object)this.subtreeSpecifications).equals(that.subtreeSpecifications);
            }
            return false;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            boolean isFirst = true;
            buffer.append("subtree { ");
            for (SubtreeSpecification ss : this.subtreeSpecifications) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buffer.append(", ");
                }
                ss.toString(buffer);
            }
            buffer.append(" }");
            return buffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UserGroup
    extends NamedUserClass {
        private static final long serialVersionUID = 8887107815072965807L;

        public UserGroup(Set<Dn> groupNames) {
            super(groupNames);
        }

        @Override
        public String toString() {
            return "userGroup " + super.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Name
    extends NamedUserClass {
        private static final long serialVersionUID = -4168412030168359882L;

        public Name(Set<Dn> usernames) {
            super(usernames);
        }

        @Override
        public String toString() {
            return "name " + super.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class NamedUserClass
    extends UserClass {
        private static final long serialVersionUID = 8571875984468893621L;
        protected final Set<Dn> names;

        protected NamedUserClass(Set<Dn> names) {
            this.names = names == null ? Collections.unmodifiableSet(new HashSet()) : Collections.unmodifiableSet(new HashSet<Dn>(names));
        }

        public Set<Dn> getNames() {
            return this.names;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass().isAssignableFrom(o.getClass())) {
                Name that = (Name)o;
                return ((Object)this.names).equals(that.names);
            }
            return false;
        }

        public int hashCode() {
            int result = 37;
            for (Dn dn : this.names) {
                result = result * 17 + dn.hashCode();
            }
            return result;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            boolean isFirst = true;
            buffer.append("{ ");
            for (Dn name : this.names) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append('\"');
                buffer.append(name.toString());
                buffer.append('\"');
            }
            buffer.append(" }");
            return buffer.toString();
        }
    }

    public static final class ParentOfEntry
    extends UserClass {
        private static final long serialVersionUID = 5247207736068086476L;

        private ParentOfEntry() {
        }

        public String toString() {
            return "parentOfEntry";
        }
    }

    public static final class ThisEntry
    extends UserClass {
        private static final long serialVersionUID = -8189325270233754470L;

        private ThisEntry() {
        }

        public String toString() {
            return "thisEntry";
        }
    }

    public static final class AllUsers
    extends UserClass {
        private static final long serialVersionUID = 8967984720792510292L;

        private AllUsers() {
        }

        public String toString() {
            return "allUsers";
        }
    }
}

