/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.DNUtils;
import org.apache.directory.shared.ldap.util.Position;
import org.apache.directory.shared.ldap.util.StringTools;

public class RdnParser {
    private static String parseOidValue(byte[] bytes, Position pos) {
        pos.start += pos.length;
        pos.end = pos.start;
        if (!StringTools.isDigit(bytes, pos.start)) {
            return null;
        }
        ++pos.end;
        while (StringTools.isDigit(bytes, pos.end)) {
            ++pos.end;
        }
        if (!StringTools.isCharASCII(bytes, pos.end, '.')) {
            return null;
        }
        do {
            ++pos.end;
            if (!StringTools.isDigit(bytes, pos.end)) {
                return null;
            }
            ++pos.end;
            while (StringTools.isDigit(bytes, pos.end)) {
                ++pos.end;
            }
        } while (StringTools.isCharASCII(bytes, pos.end, '.'));
        return StringTools.utf8ToString(bytes, pos.start - pos.length, pos.end - pos.start + pos.length);
    }

    private static boolean isValidOidValue(byte[] bytes, Position pos) {
        pos.start += pos.length;
        pos.end = pos.start;
        if (!StringTools.isDigit(bytes, pos.start)) {
            return false;
        }
        ++pos.end;
        while (StringTools.isDigit(bytes, pos.end)) {
            ++pos.end;
        }
        if (!StringTools.isCharASCII(bytes, pos.end, '.')) {
            return false;
        }
        do {
            ++pos.end;
            if (!StringTools.isDigit(bytes, pos.end)) {
                return false;
            }
            ++pos.end;
            while (StringTools.isDigit(bytes, pos.end)) {
                ++pos.end;
            }
        } while (StringTools.isCharASCII(bytes, pos.end, '.'));
        return true;
    }

    private static int parseOidPrefix(byte[] bytes, Position pos) {
        if (StringTools.isICharASCII(bytes, pos.start, 'O') && StringTools.isICharASCII(bytes, pos.start + 1, 'I') && StringTools.isICharASCII(bytes, pos.start + 2, 'D') && StringTools.isICharASCII(bytes, pos.start + 3, '.')) {
            pos.end += "oid.".length();
            return 0;
        }
        return -1;
    }

    private static String parseAttributeType(byte[] bytes, Position pos) {
        if (StringTools.isAlphaASCII(bytes, pos.start)) {
            if (RdnParser.parseOidPrefix(bytes, pos) != -1) {
                pos.length = 4;
                return RdnParser.parseOidValue(bytes, pos);
            }
            ++pos.end;
            while (StringTools.isAlphaDigitMinus(bytes, pos.end)) {
                ++pos.end;
            }
            return StringTools.utf8ToString(bytes, pos.start, pos.end - pos.start);
        }
        return RdnParser.parseOidValue(bytes, pos);
    }

    private static boolean isValidAttributeType(byte[] bytes, Position pos) {
        if (StringTools.isAlphaASCII(bytes, pos.start)) {
            if (RdnParser.parseOidPrefix(bytes, pos) != -1) {
                pos.length = 4;
                return RdnParser.isValidOidValue(bytes, pos);
            }
            ++pos.end;
            while (StringTools.isAlphaDigitMinus(bytes, pos.end)) {
                ++pos.end;
            }
            return true;
        }
        return RdnParser.isValidOidValue(bytes, pos);
    }

    /*
     * Unable to fully structure code
     */
    private static Object parseAttributeValue(byte[] bytes, Position pos) {
        if (pos.start == bytes.length) {
            return "";
        }
        c = bytes[pos.start];
        buffer = new byte[bytes.length];
        currPos = 0;
        if (c == 35) {
            ++pos.start;
            nbHex = 0;
            currentPos = pos.start;
            while (DNUtils.parseHexPair(bytes, currentPos) >= 0) {
                ++nbHex;
                currentPos += 2;
            }
            hexValue = new byte[nbHex];
            if (DNUtils.parseHexString(bytes, hexValue, pos) == -1) {
                return null;
            }
            --pos.start;
            StringTools.trimRight(bytes, pos);
            pos.length = pos.end - pos.start;
            return hexValue;
        }
        if (c == 34) {
            ++pos.start;
            pos.length = 0;
            pos.end = pos.start;
            nbBytes = 0;
            while (true) {
                if (StringTools.isCharASCII(bytes, pos.end, '\\')) {
                    ++pos.end;
                    nbChars = 0;
                    nbChars = DNUtils.countPairChar(bytes, pos.start);
                    if (nbChars != -1) {
                        pos.end += nbChars;
                        continue;
                    }
                    return null;
                }
                nbBytes = DNUtils.isQuoteChar(bytes, pos.end);
                if (nbBytes == -1) break;
                pos.end += nbBytes;
            }
            pos.length = pos.end - pos.start;
            if (StringTools.isCharASCII(bytes, pos.end, '\"')) {
                ++pos.end;
                return StringTools.utf8ToString(bytes, pos.start, pos.length);
            }
            return null;
        }
        escapedSpace = -1;
        hasPairChar = false;
        block2: while (true) {
            if (StringTools.isCharASCII(bytes, pos.end, '\\')) {
                ++pos.end;
                nbChars = 0;
                nbChars = DNUtils.countPairChar(bytes, pos.end);
                if (nbChars == -1) {
                    return null;
                }
                if (nbChars == 1) {
                    buffer[currPos++] = bytes[pos.end];
                } else {
                    if (!hasPairChar) {
                        hasPairChar = true;
                    }
                    b = StringTools.getHexValue(bytes[pos.end], bytes[pos.end + 1]);
                    buffer[currPos++] = b;
                }
                escapedSpace = bytes[pos.end] == 32 ? currPos : -1;
                pos.end += nbChars;
                continue;
            }
            nbChars = 0;
            nbChars = DNUtils.isStringChar(bytes, pos.end);
            if (nbChars == -1) break;
            if (escapedSpace != -1 && !StringTools.isCharASCII(bytes, pos.end, ' ')) {
                escapedSpace = -1;
            }
            if (StringTools.isCharASCII(bytes, pos.end, '+')) {
                if (DNUtils.isStringChar(bytes, pos.end) == -1 && !StringTools.isCharASCII(bytes, pos.end, '\\')) {
                    result = StringTools.trimRight(StringTools.utf8ToString(bytes, pos.start, pos.start + pos.length));
                    return result;
                }
                i = 0;
                while (true) {
                    if (i >= nbChars) continue block2;
                    buffer[currPos++] = bytes[pos.end];
                    ++pos.end;
                    ++i;
                }
            }
            i = 0;
            while (true) {
                if (i < nbChars) ** break;
                continue block2;
                buffer[currPos++] = bytes[pos.end];
                ++pos.end;
                ++i;
            }
            break;
        }
        pos.length = pos.end - pos.start;
        if (escapedSpace == -1) {
            result = StringTools.trimRight(StringTools.utf8ToString(buffer, currPos));
            return result;
        }
        result = StringTools.utf8ToString(buffer, escapedSpace);
        return result;
    }

    private static boolean isValidAttributeValue(byte[] bytes, Position pos) {
        if (bytes.length <= pos.start) {
            return true;
        }
        byte c = bytes[pos.start];
        if (c == 35) {
            ++pos.start;
            int nbHex = 0;
            int currentPos = pos.start;
            while (DNUtils.parseHexPair(bytes, currentPos) >= 0) {
                ++nbHex;
                currentPos += 2;
            }
            byte[] hexValue = new byte[nbHex];
            if (DNUtils.parseHexString(bytes, hexValue, pos) == -1) {
                return false;
            }
            --pos.start;
            StringTools.trimRight(bytes, pos);
            pos.length = pos.end - pos.start;
            return true;
        }
        if (c == 34) {
            ++pos.start;
            pos.length = 0;
            pos.end = pos.start;
            int nbBytes = 0;
            while (true) {
                if (StringTools.isCharASCII(bytes, pos.end, '\\')) {
                    ++pos.end;
                    int nbChars = 0;
                    nbChars = DNUtils.countPairChar(bytes, pos.start);
                    if (nbChars != -1) {
                        pos.end += nbChars;
                        continue;
                    }
                    return false;
                }
                nbBytes = DNUtils.isQuoteChar(bytes, pos.end);
                if (nbBytes == -1) break;
                pos.end += nbBytes;
            }
            pos.length = pos.end - pos.start;
            if (StringTools.isCharASCII(bytes, pos.end, '\"')) {
                ++pos.end;
                return true;
            }
            return false;
        }
        while (true) {
            int nbChars;
            if (StringTools.isCharASCII(bytes, pos.end, '\\')) {
                ++pos.end;
                nbChars = 0;
                nbChars = DNUtils.countPairChar(bytes, pos.end);
                if (nbChars == -1) {
                    return false;
                }
                pos.end += nbChars;
                continue;
            }
            nbChars = 0;
            nbChars = DNUtils.isStringChar(bytes, pos.end);
            if (nbChars == -1) break;
            if (StringTools.isCharASCII(bytes, pos.end, '+')) {
                if (DNUtils.isStringChar(bytes, pos.end) == -1 && !StringTools.isCharASCII(bytes, pos.end, '\\')) {
                    return true;
                }
                ++pos.end;
                continue;
            }
            pos.end += nbChars;
        }
        return true;
    }

    private static int parseNameComponents(byte[] bytes, Position pos, Rdn rdn) throws InvalidNameException {
        int newStart = 0;
        String type = null;
        Object value = null;
        while (true) {
            StringTools.trimLeft(bytes, pos);
            if (StringTools.isCharASCII(bytes, pos.end, '+')) {
                ++pos.start;
            } else {
                rdn.normalize();
                return 0;
            }
            StringTools.trimLeft(bytes, pos);
            type = RdnParser.parseAttributeType(bytes, pos);
            if (type == null) {
                return -1;
            }
            pos.start = pos.end;
            StringTools.trimLeft(bytes, pos);
            if (StringTools.isCharASCII(bytes, pos.end, '=')) {
                ++pos.start;
            } else {
                return -1;
            }
            StringTools.trimLeft(bytes, pos);
            value = RdnParser.parseAttributeValue(bytes, pos);
            newStart = pos.end;
            if (value != null && rdn != null) {
                rdn.addAttributeTypeAndValue(type, type, value, value);
            }
            pos.start = newStart;
            pos.end = newStart;
        }
    }

    private static boolean isValidNameComponents(byte[] bytes, Position pos, boolean isFirstRdn) {
        int newStart = 0;
        while (true) {
            StringTools.trimLeft(bytes, pos);
            if (StringTools.isCharASCII(bytes, pos.end, '+')) {
                ++pos.start;
            } else {
                return true;
            }
            StringTools.trimLeft(bytes, pos);
            if (!RdnParser.isValidAttributeType(bytes, pos)) {
                return false;
            }
            pos.start = pos.end;
            StringTools.trimLeft(bytes, pos);
            if (StringTools.isCharASCII(bytes, pos.end, '=')) {
                ++pos.start;
            } else {
                return false;
            }
            StringTools.trimLeft(bytes, pos);
            if (!RdnParser.isValidAttributeValue(bytes, pos)) {
                return false;
            }
            pos.start = newStart = pos.end;
            pos.end = newStart;
        }
    }

    public static int parse(String dn, Position pos, Rdn rdn) throws InvalidNameException {
        return RdnParser.parse(StringTools.getBytesUtf8(dn), pos, rdn);
    }

    public static int parse(byte[] dn, Position pos, Rdn rdn) throws InvalidNameException {
        String type = null;
        Object value = null;
        int start = pos.start;
        StringTools.trimLeft(dn, pos);
        pos.end = pos.start;
        pos.length = 0;
        type = RdnParser.parseAttributeType(dn, pos);
        if (type == null) {
            return -1;
        }
        if (rdn != null) {
            pos.start = pos.end;
        }
        StringTools.trimLeft(dn, pos);
        if (!StringTools.isCharASCII(dn, pos.start, '=')) {
            return -1;
        }
        ++pos.start;
        StringTools.trimLeft(dn, pos);
        pos.end = pos.start;
        value = RdnParser.parseAttributeValue(dn, pos);
        if (value == null) {
            return -1;
        }
        if (rdn != null) {
            rdn.addAttributeTypeAndValue(type, type, value, value);
            rdn.normalize();
            pos.start = pos.end;
            pos.length = 0;
        }
        if (RdnParser.parseNameComponents(dn, pos, rdn) == -1) {
            return -1;
        }
        rdn.setUpName(StringTools.utf8ToString(dn, start, pos.end - start));
        pos.start = pos.end;
        return 0;
    }

    public static boolean isValid(String dn, Position pos, boolean isfirstRdn) {
        return RdnParser.isValid(StringTools.getBytesUtf8(dn), pos, isfirstRdn);
    }

    public static boolean isValid(byte[] dn, Position pos, boolean isfirstRdn) {
        StringTools.trimLeft(dn, pos);
        pos.end = pos.start;
        pos.length = 0;
        if (!RdnParser.isValidAttributeType(dn, pos)) {
            return false;
        }
        pos.start = pos.end;
        StringTools.trimLeft(dn, pos);
        if (!StringTools.isCharASCII(dn, pos.start, '=')) {
            return false;
        }
        ++pos.start;
        StringTools.trimLeft(dn, pos);
        pos.end = pos.start;
        if (!RdnParser.isValidAttributeValue(dn, pos)) {
            return false;
        }
        pos.start = pos.end;
        pos.length = 0;
        if (!RdnParser.isValidNameComponents(dn, pos, isfirstRdn)) {
            return false;
        }
        pos.start = pos.end;
        return true;
    }

    public static void parse(String dn, Rdn rdn) throws InvalidNameException {
        RdnParser.parse(StringTools.getBytesUtf8(dn), new Position(), rdn);
    }

    public static boolean isValid(String dn) {
        return RdnParser.isValid(StringTools.getBytesUtf8(dn), new Position(), false);
    }
}

