/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import javax.naming.directory.Attribute;
import javax.naming.directory.ModificationItem;
import org.apache.directory.shared.ldap.util.AttributeUtils;

public class ModificationItemImpl
extends ModificationItem {
    private static final long serialVersionUID = 1L;
    private boolean serverModified = false;

    public ModificationItemImpl(int modificationOp, Attribute attribute) {
        super(modificationOp, AttributeUtils.toAttributeImpl(attribute));
    }

    public ModificationItemImpl(ModificationItem modification) {
        super(modification.getModificationOp(), AttributeUtils.toAttributeImpl(modification.getAttribute()));
    }

    public ModificationItemImpl(ModificationItemImpl modification) {
        super(modification.getModificationOp(), AttributeUtils.toAttributeImpl(modification.getAttribute()));
    }

    public int getModificationOp() {
        return super.getModificationOp();
    }

    public Attribute getAttribute() {
        return super.getAttribute();
    }

    public Object clone() throws CloneNotSupportedException {
        return new ModificationItemImpl(this.getModificationOp(), (Attribute)this.getAttribute().clone());
    }

    public boolean isServerModified() {
        return this.serverModified;
    }

    public void setServerModified() {
        this.serverModified = true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ModificationItem");
        if (this.serverModified) {
            sb.append("[op]");
        }
        sb.append(" : \n");
        switch (this.getModificationOp()) {
            case 1: {
                sb.append("    Add operation, ");
                break;
            }
            case 2: {
                sb.append("    Replace operation, ");
                break;
            }
            case 3: {
                sb.append("    Remove operation, ");
                break;
            }
            default: {
                sb.append("    Unknown operation, ");
            }
        }
        sb.append(AttributeUtils.toString("    ", this.getAttribute()));
        return sb.toString();
    }

    public int hashCode() {
        int hash = 37;
        hash += hash * 17 + this.getModificationOp();
        hash += hash * 17 + this.getAttribute().hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof ModificationItemImpl)) {
            return false;
        }
        ModificationItemImpl mod = (ModificationItemImpl)o;
        if (this.getModificationOp() != mod.getModificationOp()) {
            return false;
        }
        return this.getAttribute().equals(mod.getAttribute());
    }
}

