/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import org.apache.directory.shared.ldap.filter.LeafNode;

public abstract class SimpleNode
extends LeafNode {
    protected Object value;
    public static final boolean EVAL_GREATER = true;
    public static final boolean EVAL_LESSER = false;

    protected SimpleNode(String attribute, byte[] value) {
        super(attribute);
        this.value = value;
    }

    protected SimpleNode(String attribute, String value) {
        super(attribute);
        this.value = value;
    }

    public final Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public StringBuilder printToBuffer(StringBuilder buf) {
        if (null != this.getAnnotations() && this.getAnnotations().containsKey("count")) {
            buf.append(":[");
            buf.append(this.getAnnotations().get("count").toString());
            buf.append("] ");
        }
        buf.append(')');
        return buf;
    }

    public StringBuilder printRefinementToBuffer(StringBuilder buf) throws UnsupportedOperationException {
        if (this.getAttribute() == null || !"objectClass".equalsIgnoreCase(this.getAttribute())) {
            throw new UnsupportedOperationException("Invalid attribute " + this.getAttribute() + " for a refinement");
        }
        buf.append("item: ").append(this.value);
        return buf;
    }

    public int hashCode() {
        int h = 31;
        h += this.value.hashCode() * 13;
        h += this.getAttribute().hashCode() * 13;
        return h += this.getClass().hashCode() * 13;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleNode)) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        SimpleNode otherNode = (SimpleNode)other;
        if (this.value == null) {
            return otherNode.value == null;
        }
        return this.value.equals(otherNode.value);
    }
}

