/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.ldap.filter.AbstractExprNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BranchNode
extends AbstractExprNode {
    protected List<ExprNode> children = null;

    public BranchNode(List<ExprNode> children) {
        this.children = null == children ? new ArrayList<ExprNode>(2) : children;
    }

    public BranchNode() {
        this(null);
    }

    @Override
    public final boolean isLeaf() {
        return false;
    }

    public void addNode(ExprNode node) {
        this.children.add(node);
    }

    public void addNodeToHead(ExprNode node) {
        this.children.add(0, node);
    }

    public List<ExprNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<ExprNode> list) {
        this.children = list;
    }

    public ExprNode getFirstChild() {
        if (this.children.size() > 0) {
            return this.children.get(0);
        }
        return null;
    }

    @Override
    public final Object accept(FilterVisitor visitor) {
        if (visitor.isPrefix()) {
            List<ExprNode> children = visitor.getOrder(this, this.children);
            ExprNode result = null;
            if (visitor.canVisit(this)) {
                result = (ExprNode)visitor.visit(this);
            }
            for (ExprNode node : children) {
                node.accept(visitor);
            }
            return result;
        }
        if (visitor.canVisit(this)) {
            return visitor.visit(this);
        }
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BranchNode)) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        BranchNode otherExprNode = (BranchNode)other;
        List<ExprNode> otherChildren = otherExprNode.getChildren();
        if (otherChildren == this.children) {
            return true;
        }
        if (this.children.size() != otherChildren.size()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ExprNode otherChild;
            ExprNode child = this.children.get(i);
            if (child.equals(otherChild = this.children.get(i))) continue;
            return false;
        }
        return true;
    }
}

