/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.entry;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.schema.ByteArrayComparator;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryValue
implements Value<byte[]> {
    private static final Comparator<byte[]> BYTE_ARRAY_COMPARATOR = new ByteArrayComparator();
    private byte[] wrapped;

    public BinaryValue() {
    }

    public BinaryValue(byte[] wrapped) {
        this.set(wrapped);
    }

    public String toString() {
        return "BinaryValue : " + StringTools.dumpBytes(this.wrapped);
    }

    public int hashCode() {
        return Arrays.hashCode(this.wrapped);
    }

    public byte[] getCopy() {
        if (this.wrapped == null) {
            return null;
        }
        byte[] copy = new byte[this.wrapped.length];
        System.arraycopy(this.wrapped, 0, copy, 0, this.wrapped.length);
        return copy;
    }

    public byte[] getReference() {
        return this.wrapped;
    }

    @Override
    public final boolean isNull() {
        return this.wrapped == null;
    }

    @Override
    public void set(byte[] wrapped) {
        if (wrapped != null) {
            this.wrapped = new byte[wrapped.length];
            System.arraycopy(wrapped, 0, this.wrapped, 0, wrapped.length);
        } else {
            this.wrapped = null;
        }
    }

    public BinaryValue clone() throws CloneNotSupportedException {
        BinaryValue cloned = (BinaryValue)super.clone();
        if (this.wrapped != null) {
            cloned.wrapped = new byte[this.wrapped.length];
            System.arraycopy(this.wrapped, 0, cloned.wrapped, 0, this.wrapped.length);
        }
        return cloned;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        BinaryValue binaryValue = (BinaryValue)obj;
        if (this.wrapped == null && binaryValue.wrapped == null) {
            return true;
        }
        if (this.isNull() != binaryValue.isNull()) {
            return false;
        }
        return Arrays.equals(this.wrapped, binaryValue.wrapped);
    }

    public int compareTo(BinaryValue value) {
        if (value == null) {
            if (this.wrapped == null) {
                return 0;
            }
            return 1;
        }
        if (this.wrapped == null) {
            return -1;
        }
        return BYTE_ARRAY_COMPARATOR.compare(this.wrapped, value.getReference());
    }
}

