/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.common;

import java.util.Arrays;
import org.apache.directory.shared.ldap.common.AbstractValue;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryValue
extends AbstractValue<byte[]> {
    static final long serialVersionUID = 2L;

    public BinaryValue() {
        super(null);
    }

    public BinaryValue(byte[] value) {
        super(value);
    }

    public String toString() {
        return "BinaryValue : " + StringTools.dumpBytes((byte[])this.value);
    }

    public int hashCode() {
        return Arrays.hashCode((byte[])this.value);
    }

    @Override
    public BinaryValue clone() throws CloneNotSupportedException {
        BinaryValue cloned = (BinaryValue)super.clone();
        byte[] clonedValue = null;
        if (this.value != null) {
            clonedValue = this.value == null ? null : (byte[])((byte[])this.value).clone();
            System.arraycopy(this.value, 0, clonedValue, 0, ((byte[])this.value).length);
        }
        cloned.value = clonedValue;
        return cloned;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        BinaryValue value = (BinaryValue)obj;
        if (this.value == null) {
            return value.value == null;
        }
        return Arrays.equals((byte[])this.value, (byte[])value.value);
    }
}

