/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.io.UnsupportedEncodingException;
import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.DNUtils;
import org.apache.directory.shared.ldap.util.Position;
import org.apache.directory.shared.ldap.util.StringTools;

public class RdnParser {
    private static String parseOidValue(String string, Position pos) {
        pos.start += pos.length;
        pos.end = pos.start;
        if (!StringTools.isDigit(string, pos.start)) {
            return null;
        }
        ++pos.end;
        while (StringTools.isDigit(string, pos.end)) {
            ++pos.end;
        }
        if (!StringTools.isCharASCII(string, pos.end, '.')) {
            return null;
        }
        do {
            ++pos.end;
            if (!StringTools.isDigit(string, pos.end)) {
                return null;
            }
            ++pos.end;
            while (StringTools.isDigit(string, pos.end)) {
                ++pos.end;
            }
        } while (StringTools.isCharASCII(string, pos.end, '.'));
        return string.substring(pos.start - pos.length, pos.end);
    }

    private static boolean isValidOidValue(String string, Position pos) {
        pos.start += pos.length;
        pos.end = pos.start;
        if (!StringTools.isDigit(string, pos.start)) {
            return false;
        }
        ++pos.end;
        while (StringTools.isDigit(string, pos.end)) {
            ++pos.end;
        }
        if (!StringTools.isCharASCII(string, pos.end, '.')) {
            return false;
        }
        do {
            ++pos.end;
            if (!StringTools.isDigit(string, pos.end)) {
                return false;
            }
            ++pos.end;
            while (StringTools.isDigit(string, pos.end)) {
                ++pos.end;
            }
        } while (StringTools.isCharASCII(string, pos.end, '.'));
        return true;
    }

    private static int parseOidPrefix(String string, Position pos) {
        if (StringTools.isICharASCII(string, pos.start, 'O') && StringTools.isICharASCII(string, pos.start + 1, 'I') && StringTools.isICharASCII(string, pos.start + 2, 'D') && StringTools.isICharASCII(string, pos.start + 3, '.')) {
            pos.end += "oid.".length();
            return 0;
        }
        return -1;
    }

    private static String parseAttributeType(String string, Position pos) {
        if (StringTools.isAlphaASCII(string, pos.start)) {
            if (RdnParser.parseOidPrefix(string, pos) != -1) {
                pos.length = 4;
                return RdnParser.parseOidValue(string, pos);
            }
            ++pos.end;
            while (StringTools.isAlphaDigitMinus(string, pos.end)) {
                ++pos.end;
            }
            return string.substring(pos.start, pos.end);
        }
        return RdnParser.parseOidValue(string, pos);
    }

    private static boolean isValidAttributeType(String string, Position pos) {
        if (StringTools.isAlphaASCII(string, pos.start)) {
            if (RdnParser.parseOidPrefix(string, pos) != -1) {
                pos.length = 4;
                return RdnParser.isValidOidValue(string, pos);
            }
            ++pos.end;
            while (StringTools.isAlphaDigitMinus(string, pos.end)) {
                ++pos.end;
            }
            return true;
        }
        return RdnParser.isValidOidValue(string, pos);
    }

    private static Object parseAttributeValue(String string, Position pos) {
        StringBuffer sb = new StringBuffer();
        char c = StringTools.charAt(string, pos.start);
        if (c == '#') {
            ++pos.start;
            int nbHex = 0;
            int currentPos = pos.start;
            while (DNUtils.parseHexPair(string, currentPos) >= 0) {
                ++nbHex;
                currentPos += 2;
            }
            byte[] hexValue = new byte[nbHex];
            if (DNUtils.parseHexString(string, hexValue, pos) == -1) {
                return null;
            }
            --pos.start;
            StringTools.trimRight(string, pos);
            pos.length = pos.end - pos.start;
            return hexValue;
        }
        if (c == '\"') {
            ++pos.start;
            pos.length = 0;
            pos.end = pos.start;
            int nbBytes = 0;
            while (true) {
                if (StringTools.isCharASCII(string, pos.end, '\\')) {
                    ++pos.end;
                    int nbChars = 0;
                    nbChars = DNUtils.isPairChar(string, pos.start);
                    if (nbChars != -1) {
                        pos.end += nbChars;
                        continue;
                    }
                    return null;
                }
                nbBytes = DNUtils.isQuoteChar(string, pos.end);
                if (nbBytes == -1) break;
                pos.end += nbBytes;
            }
            pos.length = pos.end - pos.start;
            if (StringTools.isCharASCII(string, pos.end, '\"')) {
                ++pos.end;
                return string.substring(pos.start, pos.start + pos.length);
            }
            return null;
        }
        int escapedSpace = -1;
        boolean hasPairChar = false;
        while (true) {
            int nbChars;
            if (StringTools.isCharASCII(string, pos.end, '\\')) {
                ++pos.end;
                nbChars = 0;
                nbChars = DNUtils.isPairChar(string, pos.end);
                if (nbChars == -1) {
                    return null;
                }
                if (nbChars == 1) {
                    sb.append(string.charAt(pos.end));
                } else {
                    if (!hasPairChar) {
                        hasPairChar = true;
                    }
                    byte b = StringTools.getHexValue(string.charAt(pos.end), string.charAt(pos.end + 1));
                    sb.append((char)(b & 0xFF));
                }
                if (string.charAt(pos.end) == ' ') {
                    escapedSpace = sb.length();
                }
                pos.end += nbChars;
                continue;
            }
            nbChars = 0;
            nbChars = DNUtils.isStringChar(string, pos.end);
            if (nbChars == -1) break;
            if (StringTools.isCharASCII(string, pos.end, '+')) {
                if (DNUtils.isStringChar(string, pos.end) == -1 && !StringTools.isCharASCII(string, pos.end, '\\')) {
                    String result = string.substring(pos.start, pos.start + pos.length);
                    if (hasPairChar) {
                        return RdnParser.unescapeValue(result);
                    }
                    return result;
                }
                sb.append(string.charAt(pos.end));
                ++pos.end;
                continue;
            }
            sb.append(string.charAt(pos.end));
            pos.end += nbChars;
        }
        pos.length = pos.end - pos.start;
        String value = sb.toString();
        String result = StringTools.trimRight(value, escapedSpace);
        if (hasPairChar) {
            return RdnParser.unescapeValue(result);
        }
        return result;
    }

    private static boolean isValidAttributeValue(String string, Position pos) {
        char c = StringTools.charAt(string, pos.start);
        if (c == '#') {
            ++pos.start;
            int nbHex = 0;
            int currentPos = pos.start;
            while (DNUtils.parseHexPair(string, currentPos) >= 0) {
                ++nbHex;
                currentPos += 2;
            }
            byte[] hexValue = new byte[nbHex];
            if (DNUtils.parseHexString(string, hexValue, pos) == -1) {
                return false;
            }
            --pos.start;
            StringTools.trimRight(string, pos);
            pos.length = pos.end - pos.start;
            return true;
        }
        if (c == '\"') {
            ++pos.start;
            pos.length = 0;
            pos.end = pos.start;
            int nbBytes = 0;
            while (true) {
                if (StringTools.isCharASCII(string, pos.end, '\\')) {
                    ++pos.end;
                    int nbChars = 0;
                    nbChars = DNUtils.isPairChar(string, pos.start);
                    if (nbChars != -1) {
                        pos.end += nbChars;
                        continue;
                    }
                    return false;
                }
                nbBytes = DNUtils.isQuoteChar(string, pos.end);
                if (nbBytes == -1) break;
                pos.end += nbBytes;
            }
            pos.length = pos.end - pos.start;
            if (StringTools.isCharASCII(string, pos.end, '\"')) {
                ++pos.end;
                return true;
            }
            return false;
        }
        while (true) {
            int nbChars;
            if (StringTools.isCharASCII(string, pos.end, '\\')) {
                ++pos.end;
                nbChars = 0;
                nbChars = DNUtils.isPairChar(string, pos.end);
                if (nbChars == -1) {
                    return false;
                }
                pos.end += nbChars;
                continue;
            }
            nbChars = 0;
            nbChars = DNUtils.isStringChar(string, pos.end);
            if (nbChars == -1) break;
            if (StringTools.isCharASCII(string, pos.end, '+')) {
                if (DNUtils.isStringChar(string, pos.end) == -1 && !StringTools.isCharASCII(string, pos.end, '\\')) {
                    return true;
                }
                ++pos.end;
                continue;
            }
            pos.end += nbChars;
        }
        return true;
    }

    private static int parseNameComponents(String string, Position pos, Rdn rdn) throws InvalidNameException {
        int newStart = 0;
        String type = null;
        Object value = null;
        while (true) {
            StringTools.trimLeft(string, pos);
            if (StringTools.isCharASCII(string, pos.end, '+')) {
                ++pos.start;
            } else {
                rdn.normalize();
                return 0;
            }
            StringTools.trimLeft(string, pos);
            type = RdnParser.parseAttributeType(string, pos);
            if (type == null) {
                return -1;
            }
            pos.start = pos.end;
            StringTools.trimLeft(string, pos);
            if (StringTools.isCharASCII(string, pos.end, '=')) {
                ++pos.start;
            } else {
                return -1;
            }
            StringTools.trimLeft(string, pos);
            value = RdnParser.parseAttributeValue(string, pos);
            newStart = pos.end;
            if (value != null && rdn != null) {
                rdn.addAttributeTypeAndValue(type, type, value, value);
            }
            pos.start = newStart;
            pos.end = newStart;
        }
    }

    private static boolean isValidNameComponents(String string, Position pos, boolean isFirstRdn) {
        int newStart = 0;
        while (true) {
            StringTools.trimLeft(string, pos);
            if (StringTools.isCharASCII(string, pos.end, '+')) {
                ++pos.start;
            } else {
                return true;
            }
            StringTools.trimLeft(string, pos);
            if (!RdnParser.isValidAttributeType(string, pos)) {
                return false;
            }
            pos.start = pos.end;
            StringTools.trimLeft(string, pos);
            if (StringTools.isCharASCII(string, pos.end, '=')) {
                ++pos.start;
            } else {
                return false;
            }
            StringTools.trimLeft(string, pos);
            if (!RdnParser.isValidAttributeValue(string, pos)) {
                return false;
            }
            pos.start = newStart = pos.end;
            pos.end = newStart;
        }
    }

    private static Object unescapeValue(String value) throws IllegalArgumentException {
        byte[] bytes = new byte[value.length()];
        int pos = 0;
        for (int i = 0; i < value.length(); ++i) {
            bytes[pos++] = (byte)value.charAt(i);
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return bytes;
        }
    }

    public static int parse(String dn, Position pos, Rdn rdn) throws InvalidNameException {
        String type = null;
        Object value = null;
        int start = pos.start;
        StringTools.trimLeft(dn, pos);
        pos.end = pos.start;
        pos.length = 0;
        type = RdnParser.parseAttributeType(dn, pos);
        if (type == null) {
            return -1;
        }
        if (rdn != null) {
            pos.start = pos.end;
        }
        StringTools.trimLeft(dn, pos);
        if (!StringTools.isCharASCII(dn, pos.start, '=')) {
            return -1;
        }
        ++pos.start;
        StringTools.trimLeft(dn, pos);
        pos.end = pos.start;
        value = RdnParser.parseAttributeValue(dn, pos);
        if (value == null) {
            return -1;
        }
        if (rdn != null) {
            rdn.addAttributeTypeAndValue(type, type, value, value);
            rdn.normalize();
            pos.start = pos.end;
            pos.length = 0;
        }
        if (RdnParser.parseNameComponents(dn, pos, rdn) == -1) {
            return -1;
        }
        rdn.setUpName(dn.substring(start, pos.end));
        pos.start = pos.end;
        return 0;
    }

    public static boolean isValid(String dn, Position pos, boolean isfirstRdn) {
        StringTools.trimLeft(dn, pos);
        pos.end = pos.start;
        pos.length = 0;
        if (!RdnParser.isValidAttributeType(dn, pos)) {
            return false;
        }
        pos.start = pos.end;
        StringTools.trimLeft(dn, pos);
        if (!StringTools.isCharASCII(dn, pos.start, '=')) {
            return false;
        }
        ++pos.start;
        StringTools.trimLeft(dn, pos);
        pos.end = pos.start;
        if (!RdnParser.isValidAttributeValue(dn, pos)) {
            return false;
        }
        pos.start = pos.end;
        pos.length = 0;
        if (!RdnParser.isValidNameComponents(dn, pos, isfirstRdn)) {
            return false;
        }
        pos.start = pos.end;
        return true;
    }

    public static void parse(String string, Rdn rdn) throws InvalidNameException {
        RdnParser.parse(string, new Position(), rdn);
        rdn.normalize();
    }

    public static boolean isValid(String string) {
        return RdnParser.isValid(string, new Position(), false);
    }
}

