/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.search.controls.ChangeType;
import org.apache.directory.shared.ldap.message.AbstractMutableControlImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryChangeControl
extends AbstractMutableControlImpl {
    private static final long serialVersionUID = -2356861450876343999L;
    private static final Logger log = LoggerFactory.getLogger(EntryChangeControl.class);
    public static final String CONTROL_OID = "2.16.840.1.113730.3.4.7";
    public static final int UNDEFINED_CHANGE_NUMBER = -1;
    private ChangeType changeType = ChangeType.ADD;
    private int changeNumber = -1;
    private LdapDN previousDn = null;

    public EntryChangeControl() {
        this.setID(CONTROL_OID);
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public void setChangeType(ChangeType changeType) {
        this.changeType = changeType;
    }

    public LdapDN getPreviousDn() {
        return this.previousDn;
    }

    public void setPreviousDn(LdapDN previousDn) {
        this.previousDn = previousDn;
    }

    public int getChangeNumber() {
        return this.changeNumber;
    }

    public void setChangeNumber(int changeNumber) {
        this.changeNumber = changeNumber;
    }

    public byte[] getEncodedValue() {
        org.apache.directory.shared.ldap.codec.search.controls.EntryChangeControl ecc = new org.apache.directory.shared.ldap.codec.search.controls.EntryChangeControl();
        ecc.setChangeNumber(this.changeNumber);
        ecc.setChangeType(this.changeType);
        ecc.setPreviousDn(this.previousDn);
        try {
            return ecc.encode(null).array();
        }
        catch (EncoderException e) {
            log.error("Failed to encode psearch control", (Throwable)e);
            throw new IllegalStateException("Failed to encode control with encoder.", e);
        }
    }
}

