/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.directory.shared.ldap.message.ArrayNamingEnumeration;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.IteratorNamingEnumeration;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributesImpl
implements Attributes {
    static final transient long serialVersionUID = 1L;
    private boolean ignoreCase;
    private Map<String, Holder> keyMap;

    public AttributesImpl() {
        this.keyMap = new HashMap<String, Holder>();
        this.ignoreCase = true;
    }

    public AttributesImpl(boolean ignoreCase) {
        this.keyMap = new HashMap<String, Holder>();
        this.ignoreCase = ignoreCase;
    }

    public AttributesImpl(String id, Object value) {
        this.keyMap = new HashMap<String, Holder>();
        this.put(id, value);
        this.ignoreCase = true;
    }

    public AttributesImpl(String id, Object value, boolean ignoreCase) {
        this.keyMap = new HashMap<String, Holder>();
        this.put(id, value);
        this.ignoreCase = ignoreCase;
    }

    public AttributesImpl(Attributes attributes) throws NamingException {
        if (attributes == null) {
            throw new NamingException("Cannot  create a copy of a null element");
        }
        if (attributes instanceof BasicAttributes) {
            this.ignoreCase = attributes.isCaseIgnored();
            NamingEnumeration<? extends Attribute> attrs = attributes.getAll();
            this.keyMap = new HashMap<String, Holder>();
            while (attrs.hasMoreElements()) {
                AttributeImpl attribute = new AttributeImpl((Attribute)attrs.nextElement());
                this.put(attribute);
            }
        } else if (attributes instanceof AttributesImpl) {
            try {
                AttributesImpl clone = (AttributesImpl)attributes.clone();
                this.keyMap = new HashMap<String, Holder>(clone.keyMap.size());
                for (String key : clone.keyMap.keySet()) {
                    Holder holder = clone.keyMap.get(key);
                    this.keyMap.put(key, (Holder)holder.clone());
                }
                this.ignoreCase = clone.ignoreCase;
            }
            catch (CloneNotSupportedException cnse) {
                throw new NamingException("Cannot copy a value inro the new atributes element");
            }
        } else {
            throw new NamingException("Cannot create a copy of a object which is not an instance of AttributesImpl or of BasicAttributes");
        }
    }

    @Override
    public boolean isCaseIgnored() {
        return this.ignoreCase;
    }

    @Override
    public int size() {
        return this.keyMap.size();
    }

    @Override
    public Attribute get(String attrId) {
        if (attrId != null) {
            String key = this.idToLowerCase(attrId);
            Holder holder = this.keyMap.get(key);
            return holder != null ? holder.attribute : null;
        }
        return null;
    }

    public NamingEnumeration<Attribute> getAll() {
        return new IteratorNamingEnumeration<Attribute>(new AttributeIterator(this));
    }

    @Override
    public NamingEnumeration<String> getIDs() {
        String[] ids = new String[this.keyMap.size()];
        Iterator<Holder> values = this.keyMap.values().iterator();
        int i = 0;
        while (values.hasNext()) {
            ids[i++] = values.next().upId;
        }
        return new ArrayNamingEnumeration<String>(ids);
    }

    @Override
    public Attribute put(String attrId, Object val) {
        AttributeImpl attr = new AttributeImpl(attrId);
        attr.add(val);
        String key = this.idToLowerCase(attrId);
        this.keyMap.put(key, new Holder(attrId, attr));
        return attr;
    }

    @Override
    public Attribute put(Attribute attr) {
        String id = attr.getID();
        String key = this.idToLowerCase(id);
        Attribute old = null;
        Attribute newAttr = attr;
        old = this.keyMap.containsKey(key) ? this.keyMap.remove(key).attribute : attr;
        if (attr instanceof AttributeImpl) {
            newAttr = attr;
        } else if (attr instanceof BasicAttribute) {
            newAttr = new AttributeImpl(id);
            try {
                NamingEnumeration<?> values = attr.getAll();
                while (values.hasMore()) {
                    newAttr.add(AttributeUtils.cloneValue(values.next()));
                }
            }
            catch (NamingException ne) {
                // empty catch block
            }
        }
        this.keyMap.put(key, new Holder(id, newAttr));
        return old;
    }

    @Override
    public Attribute remove(String attrId) {
        String key = this.idToLowerCase(attrId);
        if (this.keyMap.containsKey(key)) {
            Holder holder = this.keyMap.remove(key);
            if (holder != null) {
                return holder.attribute;
            }
            return null;
        }
        return null;
    }

    private String idToLowerCase(String id) {
        String key = null;
        key = "+".equals(id) || "*".equals(id) ? id : StringTools.toLowerCase(id);
        return key;
    }

    @Override
    public Object clone() {
        try {
            AttributesImpl clone = (AttributesImpl)super.clone();
            clone.keyMap = new HashMap<String, Holder>(this.keyMap.size());
            for (String key : this.keyMap.keySet()) {
                Holder holder = this.keyMap.get(key);
                clone.keyMap.put(key, (Holder)holder.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (Holder holder : this.keyMap.values()) {
            Attribute attr = holder.attribute;
            buf.append(holder.upId);
            buf.append(": ");
            buf.append(attr);
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof AttributesImpl)) {
            return false;
        }
        Attributes attrs = (Attributes)obj;
        if (attrs.size() != this.size()) {
            return false;
        }
        if (attrs.isCaseIgnored() != this.isCaseIgnored()) {
            return false;
        }
        NamingEnumeration<? extends Attribute> list = attrs.getAll();
        while (list.hasMoreElements()) {
            Attribute attr = (Attribute)list.nextElement();
            Attribute myAttr = this.get(attr.getID());
            if (myAttr == null) {
                return false;
            }
            if (myAttr.equals(attr)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AttributeIterator<T>
    implements Iterator<Attribute> {
        private Iterator<Holder> iterator;

        private AttributeIterator(AttributesImpl attributes) {
            this.iterator = attributes.keyMap.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Attribute next() {
            return this.iterator.next().attribute;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private class Holder
    implements Serializable,
    Cloneable {
        static final transient long serialVersionUID = 1L;
        private String upId;
        private Attribute attribute;

        private Holder(String upId, Attribute attribute) {
            this.upId = upId;
            this.attribute = attribute;
        }

        public Object clone() throws CloneNotSupportedException {
            Holder clone = (Holder)super.clone();
            clone.upId = this.upId;
            if (this.attribute instanceof BasicAttribute) {
                clone.attribute = new AttributeImpl(this.attribute.getID());
                try {
                    NamingEnumeration<?> values = this.attribute.getAll();
                    while (values.hasMoreElements()) {
                        clone.attribute.add(AttributeUtils.cloneValue(values.nextElement()));
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            clone.attribute = (Attribute)this.attribute.clone();
            return clone;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.upId).append(": ");
            sb.append(this.attribute).append('\n');
            return sb.toString();
        }
    }
}

